/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.MetricValueBase;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class NumericMetricValue
extends MetricValueBase<Double> {
    private static final long serialVersionUID = 1771817445263976660L;

    @JsonCreator
    public NumericMetricValue(@JsonProperty(value="schemaEntry") MetricDirectorySchemaEntry schemaEntry, @JsonProperty(value="value") Double value) {
        super(schemaEntry, value);
    }

    @Override
    public EMetricValueType getValueType() {
        return EMetricValueType.NUMERIC;
    }

    @Override
    protected @Nullable MetricValueBase<Double> computeDelta(MetricValueBase<Double> baseValue) {
        return new NumericMetricValue(this.getSchemaEntry(), (Double)this.getOrDefault() - baseValue.getOrDefault());
    }

    public static DecimalFormat createNumberFormat(String pattern) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        decimalFormat.applyPattern(pattern);
        return decimalFormat;
    }

    @Override
    protected double getPresentValueAsDouble(ETrafficLightColor color) {
        return (Double)this.getRawValue();
    }
}

