/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion107GitHubInstallationUrl
implements IPointwiseStorageMigrator {
    private static final String ORGANISATION_TO_INSTALLATION_PREFIX = "o2i:";
    private static final String SEPARATOR = "#";

    @Override
    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        String keyString = StringUtils.bytesToString((byte[])key);
        if (keyString.startsWith(ORGANISATION_TO_INSTALLATION_PREFIX)) {
            String url = keyString.substring(ORGANISATION_TO_INSTALLATION_PREFIX.length(), keyString.indexOf(SEPARATOR));
            String suffix = keyString.substring(keyString.indexOf(SEPARATOR));
            String canonicalUrl = StringUtils.stripSuffix((String)url, (String)"/");
            String newKeyString = ORGANISATION_TO_INSTALLATION_PREFIX + canonicalUrl + suffix;
            return PairList.from((Object)StringUtils.stringToBytes((String)newKeyString), (Object)value);
        }
        return PairList.from((Object)key, (Object)value);
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V107;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    public String getStoreName() {
        return "github-installations";
    }
}

