/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.core.utils.TimestampedInteraction;
import java.util.LinkedList;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class MigrateVersion109UserRecentActivityIndicesBase
implements IPointwiseStorageMigrator {
    private static final String IGNORED_KEY = "last-change-timestamp-key";

    @Override
    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        if (IGNORED_KEY.equals(StringUtils.bytesToString((byte[])key))) {
            return PairList.from((Object)key, (Object)value);
        }
        LinkedList identifiers = (LinkedList)StorageUtils.deserialize((byte[])value);
        LinkedList newItems = new LinkedList();
        identifiers.forEach(branch -> newItems.add(new TimestampedInteraction<String>(System.currentTimeMillis(), (String)branch)));
        return PairList.from((Object)key, (Object)StorageUtils.serialize(newItems));
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V109;
    }
}

