/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion120AddHidePercentageBadgeParameter
extends ReportSlideMigratorBase {
    private static final String TGA_TREEMAP_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.TestGapTreemapSlide";
    private static final String TGA_TREEMAP_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.TestGapTreemapSlideTestGapTreemapSlideParameters";
    private static final String HIDE_PERCENTAGE_BADGE_PARAMETER_NAME = "hidePercentageBadge";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        this.updateShowPercentageBadgeForSlideType(entityPool, TGA_TREEMAP_SLIDE_CLASS, TGA_TREEMAP_PARAMETER_CLASS);
    }

    private void updateShowPercentageBadgeForSlideType(SerializedEntityPool entityPool, String slideClass, String slideParameterClass) throws IOException {
        for (SerializedObject detailSlide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(slideClass), (SerializedEntityPool)entityPool)) {
            SerializedClass serializedClass = entityPool.findClass(slideParameterClass);
            if (serializedClass != null && !serializedClass.containsField(HIDE_PERCENTAGE_BADGE_PARAMETER_NAME)) {
                serializedClass.addField((SerializedFieldBase)new SerializedIntField(HIDE_PERCENTAGE_BADGE_PARAMETER_NAME));
            }
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)detailSlide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(HIDE_PERCENTAGE_BADGE_PARAMETER_NAME, (Object)false);
            SerializedObject slideParameterDescriptorsObject = (SerializedObject)entityPool.getEntity(((Integer)slideParameters.getFieldValue("parameterDescriptors")).intValue(), SerializedObject.class);
            SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy((SerializedObject)slideParameterDescriptorsObject, ArrayList.class);
            SerializedClassValues fieldSets = slideParameterDescriptorsObject.getFieldSet(slideParameterDescriptorsObject.getPlainClassHierarchy().indexOf(listClass));
            SerializedObject newParameterDescriptor = MigrateVersion120AddHidePercentageBadgeParameter.createParameterDescriptorObject(entityPool, HIDE_PERCENTAGE_BADGE_PARAMETER_NAME, "Hide Percentage Badge", "BOOLEAN", "");
            fieldSets.getPostFieldData().add(5, newParameterDescriptor.getHandle());
            fieldSets.setValue(0, (Object)6);
            SerializedObject updatedParameterDescriptors = new SerializedObject(slideParameterDescriptorsObject.getClassHandle(), Collections.singletonList(fieldSets), entityPool);
            slideParameters.setFieldValue("parameterDescriptors", (Object)updatedParameterDescriptors.getHandle());
        }
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V120;
    }
}

