/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion148SapRemoveBgRfc
extends SerializedValueMigratorBase {
    private static final String SERIALIZED_CLASS_NAME = "com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription";
    private static final String TRIGGER_FIELD_NAME = "useBgRfcForAsynchronousSynchronization";
    private static final String TARGET_FIELD_NAME = "executeFullSynchronizationAsynchronously";

    public MigrateVersion148SapRemoveBgRfc() {
        super(true);
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass serializedClass = entityPool.findClass(SERIALIZED_CLASS_NAME);
        if (serializedClass == null) {
            return;
        }
        List instances = SerializedEntityUtils.findInstancesOf((SerializedClass)serializedClass, (SerializedEntityPool)entityPool);
        for (SerializedObject serializedObject : instances) {
            Boolean triggerField = (Boolean)serializedObject.getFieldValue(TRIGGER_FIELD_NAME);
            if (triggerField == null || !triggerField.booleanValue()) continue;
            serializedObject.setFieldValue(TARGET_FIELD_NAME, (Object)Boolean.FALSE);
        }
    }

    @Override
    public String getStoreName() {
        return "server-options";
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V148;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }
}

