/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion156LineCoverageInfoTimestamps
extends BranchBasedStoreBatchMigratorBase {
    private static final String LINE_COVERAGE_INFO_CLASS = "org.conqat.engine.sourcecode.coverage.LineCoverageInfo";

    protected MigrateVersion156LineCoverageInfoTimestamps() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V156, true);
    }

    @Override
    protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            MigrateVersion156LineCoverageInfoTimestamps.migrateLineCoverageInfos(entityPool);
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static void migrateLineCoverageInfos(SerializedEntityPool entityPool) throws IOException {
        SerializedClassFieldMigrator fieldMigrator = new SerializedClassFieldMigrator(entityPool);
        fieldMigrator.removeField(LINE_COVERAGE_INFO_CLASS, "timestamp");
        fieldMigrator.addLongField(LINE_COVERAGE_INFO_CLASS, "uploadCommitTimestamp", -1L);
        fieldMigrator.addLongField(LINE_COVERAGE_INFO_CLASS, "codeCommitTimestamp", -1L);
    }

    @Override
    public String getStoreName() {
        return "external-analysis-results";
    }
}

