/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="rollback.age-limit", name="Automatic Rollback Age Limit", type=EOptionType.SERVER, category=EOptionCategory.LIMITS)
@IndexValueClass(containedInBackup=true)
public class RollbackLimitOption
implements IOption {
    private static final int DEFAULT_AGE_THRESHOLD_HOURS = 8760;
    private static final int DEFAULT_COMMIT_COUNT_THRESHOLD = 0;
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "rollback.age-limit";
    public static final String OPTION_NAME = "Automatic Rollback Age Limit";
    @JsonProperty(value="rollbackAgeThresholdHours")
    @OptionFieldDescription(name="Age threshold in hours for which a rollback is executed automatically.", description="Rollbacks that reach back to an earlier time may be paused and queued for manual acknowledgement.")
    public int rollbackAgeThresholdHours = 8760;
    @JsonProperty(value="rollbackCommitCountThreshold")
    @OptionFieldDescription(name="Number of commits until which rollbacks are always executed automatically ", description="Rollbacks that roll back more than this number of commits may be paused and queued for manual acknowledgement (according to the age threshold). Rollbacks that affect less commits than this threshold are not subject to the age limit (i.e. small but old rollbacks may be executed). A value of 0 ensures that rollbacks are only subject to the age threshold and rollbacks of any old commits are postponed.")
    public int rollbackCommitCountThreshold = 0;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (this.rollbackAgeThresholdHours <= 0) {
            return "Age threshold must be positive!";
        }
        if (this.rollbackCommitCountThreshold < 0) {
            return "Commit count threshold must be positive or 0!";
        }
        return null;
    }

    public static int getAgeThresholdHours(ServerOptionIndex serverOptionIndex) throws StorageException {
        RollbackLimitOption option = ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, RollbackLimitOption.class, serverOptionIndex);
        if (option == null) {
            return 8760;
        }
        return option.rollbackAgeThresholdHours;
    }

    public static int getCommitCountThreshold(ServerOptionIndex serverOptionIndex) throws StorageException {
        RollbackLimitOption option = ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, RollbackLimitOption.class, serverOptionIndex);
        if (option == null) {
            return 0;
        }
        return option.rollbackCommitCountThreshold;
    }
}

