/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PermissionIndexKeyUtils {
    private static final String KEY_DELIMITER = "#";

    public static String createRoleAssignmentKey(ISubject subject) {
        return PermissionIndexKeyUtils.createRoleAssignmentKey(subject.getSubjectType(), subject.getSubjectId());
    }

    public static String createRoleAssignmentKey(ESubjectType subjectType, String subjectId) {
        return String.valueOf((Object)EEntryType.ROLE_ASSIGNMENTS) + KEY_DELIMITER + String.valueOf((Object)subjectType) + KEY_DELIMITER + subjectId;
    }

    public static String createAllRoleAssignmentKeyPrefix() {
        return EEntryType.ROLE_ASSIGNMENTS.toString();
    }

    public static String createAllProjectRoleKeyPrefix() {
        return EEntryType.PROJECT_ROLE.toString();
    }

    public static String createProjectRoleKey(String roleId) {
        return String.valueOf((Object)EEntryType.PROJECT_ROLE) + KEY_DELIMITER + roleId;
    }

    public static String createAllGlobalRoleKeyPrefix() {
        return EEntryType.GLOBAL_ROLE.toString();
    }

    public static String createGlobalRoleKey(String roleId) {
        return String.valueOf((Object)EEntryType.GLOBAL_ROLE) + KEY_DELIMITER + roleId;
    }

    public static String createGroupRoleAssignmentKey() {
        return String.valueOf((Object)EEntryType.ROLE_ASSIGNMENTS) + KEY_DELIMITER + String.valueOf((Object)ESubjectType.GROUP) + KEY_DELIMITER;
    }

    private PermissionIndexKeyUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static enum EEntryType {
        PROJECT_ROLE,
        GLOBAL_ROLE,
        ROLE_ASSIGNMENTS;

    }
}

