/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.precommit;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PreCommitUtils {
    public static final String PRECOMMIT_BRANCH_PREFIX = "__precommit__";
    private static final String PRECOMMIT_COMMIT_INFIX = "__commit__";
    private static final String PRECOMMIT_BRANCH_INFIX = "__branch__";
    public static final String PRECOMMIT_BRANCH_ALIAS = "'s pre-commit branch";
    public static final String PRECOMMIT_REPOSITORY_IDENTIFIER = "__precommit__";
    public static final String PRE_COMMIT_UPLOAD_CHANGE_RETRIEVER_TRIGGER_NAME = "PreCommitUploadChangeRetriever";

    public static boolean isPrecommitBranch(String branch) {
        return branch.startsWith("__precommit__");
    }

    public static boolean isPrecommitCommit(CommitDescriptor commit) {
        return PreCommitUtils.isPrecommitBranch(commit.getBranchName());
    }

    public static boolean isPrecommitJob(JobDescriptor job) {
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        return schedulingCommit != null && PreCommitUtils.isPrecommitCommit(schedulingCommit);
    }

    public static String createPrecommitBranchNameForCommitId(String username, String commitId) {
        return "__precommit__" + username + PRECOMMIT_COMMIT_INFIX + commitId;
    }

    public static String createPrecommitBranchNameForBranchName(String username, String branchName) {
        return "__precommit__" + username + PRECOMMIT_BRANCH_INFIX + branchName;
    }

    public static boolean isPrecommitChangeRetriever(String triggerName) {
        return PRE_COMMIT_UPLOAD_CHANGE_RETRIEVER_TRIGGER_NAME.equals(triggerName);
    }

    public static String extractPrecommitUserName(String preCommitBranch) {
        String result = StringUtils.stripPrefix((String)preCommitBranch, (String)"__precommit__");
        if (result.contains(PRECOMMIT_BRANCH_INFIX)) {
            return result.substring(0, result.indexOf(PRECOMMIT_BRANCH_INFIX));
        }
        if (result.contains(PRECOMMIT_COMMIT_INFIX)) {
            return result.substring(0, result.indexOf(PRECOMMIT_COMMIT_INFIX));
        }
        return result;
    }

    public static boolean isPrecommitBranchName(String branchName) {
        return branchName.startsWith("__precommit__") && (branchName.contains(PRECOMMIT_BRANCH_INFIX) || branchName.contains(PRECOMMIT_COMMIT_INFIX));
    }

    public static void deletePrecommitBranches(IBranchingLayer branchingLayer, List<String> preCommitBranches, InternalProjectId internalProjectId, IndexLayer indexLayer, String deletionReason) throws StorageException {
        HashMap<String, Long> timestampByBranch = new HashMap<String, Long>();
        for (String preCommitBranch : preCommitBranches) {
            if (branchingLayer.getCommitInfosForBranch(preCommitBranch).isEmpty()) continue;
            timestampByBranch.put(preCommitBranch, 1L);
        }
        branchingLayer.performRollback(timestampByBranch);
        for (String preCommitBranch : timestampByBranch.keySet()) {
            PreCommitUtils.scheduleRollback(new CommitDescriptor(preCommitBranch, 1L), preCommitBranch, internalProjectId, indexLayer, deletionReason + " Target branch: " + preCommitBranch);
        }
    }

    private static void scheduleRollback(CommitDescriptor parentCommit, String preCommitBranch, InternalProjectId internalProjectId, IndexLayer indexLayer, String deletionReason) throws StorageException {
        CommitDescriptor rollbackCommit = new CommitDescriptor(preCommitBranch, parentCommit.getTimestamp() + 1L);
        JobDescriptor rollbackJob = new JobDescriptor(internalProjectId, ForceRollbackTrigger.class, rollbackCommit, deletionReason, UUID.randomUUID());
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, rollbackJob);
    }

    private PreCommitUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

