/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.core.MediaType;

public class MoreMediaTypes {
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_VND_MS_FONTOBJECT = "application/vnd.ms-fontobject";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_SVG = "image/svg+xml";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_X_ICON = "image/x-icon";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_CSV = "text/csv";
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String TEXT_MARKDOWN = "text/markdown";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String FONT_WOFF = "font/woff";
    public static final String FONT_WOFF2 = "font/woff2";
    public static final String FONT_TTF = "font/ttf";
    public static final MediaType APPLICATION_ZIP_TYPE;
    public static final MediaType IMAGE_PNG_TYPE;
    public static final MediaType TEXT_CSV_TYPE;
    public static final MediaType TEXT_MARKDOWN_TYPE;
    public static final MediaType TEXT_JAVASCRIPT_TYPE;
    public static final MediaType APPLICATION_YAML_TYPE;
    public static final ImmutableMap<String, MediaType> EXTENSIONS;

    private static MediaType register(String mediaType, ImmutableMap.Builder<String, MediaType> extensionsMap, String ... extensions) {
        return MoreMediaTypes.register(MediaType.valueOf((String)mediaType), extensionsMap, extensions);
    }

    private static MediaType register(MediaType mediaType, ImmutableMap.Builder<String, MediaType> extensionsMap, String ... extensions) {
        for (String extension : extensions) {
            extensionsMap.put((Object)extension, (Object)mediaType);
        }
        return mediaType;
    }

    static {
        ImmutableMap.Builder extensions = ImmutableMap.builder();
        APPLICATION_ZIP_TYPE = MoreMediaTypes.register(APPLICATION_ZIP, (ImmutableMap.Builder<String, MediaType>)extensions, "zip");
        TEXT_CSV_TYPE = MoreMediaTypes.register(TEXT_CSV, (ImmutableMap.Builder<String, MediaType>)extensions, "csv");
        TEXT_MARKDOWN_TYPE = MoreMediaTypes.register(TEXT_MARKDOWN, (ImmutableMap.Builder<String, MediaType>)extensions, "md");
        IMAGE_PNG_TYPE = MoreMediaTypes.register(IMAGE_PNG, (ImmutableMap.Builder<String, MediaType>)extensions, "png");
        APPLICATION_YAML_TYPE = MoreMediaTypes.register(APPLICATION_YAML, (ImmutableMap.Builder<String, MediaType>)extensions, "yaml", "yml");
        TEXT_JAVASCRIPT_TYPE = MoreMediaTypes.register(TEXT_JAVASCRIPT, (ImmutableMap.Builder<String, MediaType>)extensions, "js");
        MoreMediaTypes.register(IMAGE_SVG, (ImmutableMap.Builder<String, MediaType>)extensions, "svg");
        MoreMediaTypes.register(TEXT_CSS, (ImmutableMap.Builder<String, MediaType>)extensions, "css");
        MoreMediaTypes.register(FONT_WOFF, (ImmutableMap.Builder<String, MediaType>)extensions, "woff");
        MoreMediaTypes.register(FONT_WOFF2, (ImmutableMap.Builder<String, MediaType>)extensions, "woff2");
        MoreMediaTypes.register(APPLICATION_VND_MS_FONTOBJECT, (ImmutableMap.Builder<String, MediaType>)extensions, "eot");
        MoreMediaTypes.register(FONT_TTF, (ImmutableMap.Builder<String, MediaType>)extensions, "ttf");
        MoreMediaTypes.register(IMAGE_X_ICON, (ImmutableMap.Builder<String, MediaType>)extensions, "ico");
        MoreMediaTypes.register(IMAGE_GIF, (ImmutableMap.Builder<String, MediaType>)extensions, "gif");
        MoreMediaTypes.register(IMAGE_JPEG, (ImmutableMap.Builder<String, MediaType>)extensions, "jpg", "jpeg");
        MoreMediaTypes.register(MediaType.APPLICATION_OCTET_STREAM_TYPE, (ImmutableMap.Builder<String, MediaType>)extensions, "map");
        MoreMediaTypes.register(MediaType.TEXT_PLAIN_TYPE, (ImmutableMap.Builder<String, MediaType>)extensions, "txt", "sublime-build");
        MoreMediaTypes.register(MediaType.TEXT_HTML_TYPE, (ImmutableMap.Builder<String, MediaType>)extensions, "html");
        MoreMediaTypes.register(MediaType.APPLICATION_JSON_TYPE, (ImmutableMap.Builder<String, MediaType>)extensions, "json", "json5");
        MoreMediaTypes.register(MediaType.APPLICATION_XML_TYPE, (ImmutableMap.Builder<String, MediaType>)extensions, "xml");
        EXTENSIONS = extensions.build();
    }
}

