/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.performance;

import com.teamscale.core.runtime.api.progress.EAnalysisState;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StoreOperationStatistics;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class PerformanceDetailEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EAnalysisState state;
    private final String trigger;
    private final PublicProjectId projectId;
    private final @Nullable CommitDescriptor schedulingCommit;
    private final WorkerPerformanceData mainWorkerPerformance;
    private final List<WorkerPerformanceData> supportingWorkerPerformance;
    private final long storageCalls;
    private final long storageTimeMillis;
    private LinkedHashMap<String, Long> sectionTimeMillis;
    private Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> storeOperationStatisticsByStore = null;

    public PerformanceDetailEntry(EAnalysisState state, String trigger, PublicProjectId projectId, @Nullable CommitDescriptor schedulingCommit, WorkerPerformanceData mainWorkerPerformance, List<WorkerPerformanceData> supportingWorkerPerformance, long storageCalls, long storageTimeMillis) {
        this.state = state;
        this.trigger = trigger;
        this.projectId = projectId;
        this.mainWorkerPerformance = mainWorkerPerformance;
        this.supportingWorkerPerformance = new ArrayList<WorkerPerformanceData>(supportingWorkerPerformance);
        this.schedulingCommit = schedulingCommit;
        this.storageCalls = storageCalls;
        this.storageTimeMillis = storageTimeMillis;
    }

    public EAnalysisState getState() {
        return this.state;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public PublicProjectId getProjectId() {
        return this.projectId;
    }

    public CommitDescriptor getSchedulingCommit() {
        return this.schedulingCommit;
    }

    public WorkerPerformanceData getMainWorkerPerformance() {
        return this.mainWorkerPerformance;
    }

    public UnmodifiableList<WorkerPerformanceData> getSupportingWorkerPerformance() {
        return CollectionUtils.asUnmodifiable(this.supportingWorkerPerformance);
    }

    public Stream<WorkerPerformanceData> getWorkerPerformance() {
        return Stream.concat(Stream.of(this.mainWorkerPerformance), this.supportingWorkerPerformance.stream());
    }

    public int getParallelism() {
        return (int)this.getWorkerPerformance().map(WorkerPerformanceData::workerId).distinct().count();
    }

    public long getStorageCalls() {
        return this.storageCalls;
    }

    public long getStorageTimeMillis() {
        return this.storageTimeMillis;
    }

    public Map<String, Long> getSectionTimeMillis() {
        if (this.sectionTimeMillis == null) {
            return Collections.emptyMap();
        }
        return this.sectionTimeMillis;
    }

    public void addSectionTime(String sectionName, long millis) {
        if (this.sectionTimeMillis == null) {
            this.sectionTimeMillis = new LinkedHashMap();
        }
        this.sectionTimeMillis.put(sectionName, millis);
    }

    public Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> getStoreOperationStatisticsByStore() {
        return this.storeOperationStatisticsByStore;
    }

    public void setStoreOperationStatisticsByStore(Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> storeOperationStatisticsByStore) {
        this.storeOperationStatisticsByStore = storeOperationStatisticsByStore;
    }

    @IndexValueClass
    public record WorkerPerformanceData(String workerId, Instant startTime, Duration duration, long maxMemoryBytes) implements Serializable
    {
        public Instant endTime() {
            return this.startTime.plus(this.duration);
        }
    }
}

