/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.performance;

import com.teamscale.core.runtime.api.performance.PerformanceMetricsEntry;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="performance-metrics", options={EStorageOption.COMPRESSED}, valueClasses={PerformanceMetricsEntry.class})
public class PerformanceMetricsIndex
extends IndexBase
implements IGlobalIndex {
    private static final byte[] KEEP_KEY_PREFIX = new byte[]{107};

    public PerformanceMetricsIndex(IStore store) {
        super(store);
    }

    public synchronized void recordMetrics(long timestamp, WorkerClusterStatus clusterStatus, CompletedRevisionSupport completedRevisions) throws StorageException {
        PerformanceMetricsEntry entry = new PerformanceMetricsEntry(timestamp, clusterStatus.getSchedulerLoad(), clusterStatus.getWorkerLoad(), completedRevisions.getCompletedRevisionsPerSecond(timestamp), clusterStatus.getJobQueueSize());
        byte[] serialized = StorageUtils.serialize((Serializable)entry);
        PairList keysValues = new PairList();
        for (byte[] key : PerformanceMetricsIndex.determineStorageKeys(timestamp)) {
            keysValues.add((Object)key, (Object)serialized);
        }
        this.store.put(keysValues);
    }

    private static List<byte[]> determineStorageKeys(long timestamp) {
        long roundedToSeconds = (timestamp + 500L) / 1000L;
        byte[] oneSecondBufferKey = new byte[]{114, 49, (byte)(roundedToSeconds % 60L)};
        byte[] fiveSecondBufferKey = new byte[]{114, 53, (byte)(roundedToSeconds % 180L / 5L)};
        byte[] keepKey = ByteArrayUtils.concat((byte[][])new byte[][]{KEEP_KEY_PREFIX, ByteArrayUtils.longToByteArray((long)((roundedToSeconds - roundedToSeconds % 60L) * 1000L))});
        return Arrays.asList(oneSecondBufferKey, fiveSecondBufferKey, keepKey);
    }

    public List<PerformanceMetricsEntry> getMetricsTrend(long startTime) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(ByteArrayUtils.concat((byte[][])new byte[][]{KEEP_KEY_PREFIX, ByteArrayUtils.longToByteArray((long)startTime)}), null, (IKeyValueCallback)callback);
        HashSet seenTimestamp = new HashSet();
        return callback.getResultOrThrowException().stream().filter(entry -> entry.getTimestamp() >= startTime && seenTimestamp.add(entry.getTimestamp())).sorted(Comparator.comparing(PerformanceMetricsEntry::getTimestamp)).collect(Collectors.toList());
    }

    public static class CompletedRevisionSupport {
        private static final Duration COMMIT_AGGREGATION_INTERVAL = DurationUtils.ONE_MINUTE;
        private final Map<Long, Integer> startTimeToCompletedRevisions = new HashMap<Long, Integer>();
        private int completedRevisionsSinceLastRecording;
        private long lastRecording = 0L;

        public synchronized void reportCompletedRevision() {
            ++this.completedRevisionsSinceLastRecording;
        }

        private synchronized double getCompletedRevisionsPerSecond(long timestamp) {
            if (this.lastRecording > 0L) {
                this.startTimeToCompletedRevisions.put(this.lastRecording, this.completedRevisionsSinceLastRecording);
            }
            this.completedRevisionsSinceLastRecording = 0;
            this.lastRecording = timestamp;
            long cutOffTime = timestamp - COMMIT_AGGREGATION_INTERVAL.toMillis();
            this.startTimeToCompletedRevisions.keySet().removeIf(startTime -> startTime < cutOffTime);
            return (double)this.startTimeToCompletedRevisions.values().stream().mapToInt(x -> x).sum() / (double)COMMIT_AGGREGATION_INTERVAL.toSeconds();
        }
    }
}

