/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.IIndexDelta;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="delta", options={EStorageOption.COMPRESSED}, valueClasses={IIndexDelta.class})
public class DeltaIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "delta";

    public DeltaIndex(IStore store) {
        super(store);
    }

    public List<IIndexDelta> getDeltasForIds(List<Long> deltaIds) throws StorageException {
        List values = this.store.get(CollectionUtils.map(deltaIds, ByteArrayUtils::longToByteArray));
        return CollectionUtils.mapWithException((Collection)values, StorageUtils::deserialize);
    }

    public void putDeltas(PairList<Long, IIndexDelta> deltasToWrite) throws StorageException {
        PairList keysValues = new PairList();
        for (int i = 0; i < deltasToWrite.size(); ++i) {
            keysValues.add((Object)ByteArrayUtils.longToByteArray((long)((Long)deltasToWrite.getFirst(i))), (Object)StorageUtils.serialize((Serializable)((Serializable)deltasToWrite.getSecond(i))));
        }
        this.store.put(keysValues);
    }

    public void removeDeltas(List<Long> deltaIdsToRemove) throws StorageException {
        this.store.remove(CollectionUtils.map(deltaIdsToRemove, ByteArrayUtils::longToByteArray));
    }
}

