/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.google.common.base.Preconditions;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ScheduledJob
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final JobDescriptor job;
    private final PairList<String, Long> inputDeltas = new PairList();
    private final PairList<String, Long> virtualStores = new PairList();
    private final Set<String> requiredDeltas;
    private final long earliestScheduleTimestamp;
    private final int retryCount;

    public ScheduledJob(long id, JobDescriptor job) {
        this(id, job, null);
    }

    public ScheduledJob(long id, JobDescriptor job, Collection<String> requiredDeltas) {
        this(id, job, requiredDeltas, null, null, 0L, 0);
    }

    public ScheduledJob(long id, JobDescriptor job, Collection<String> requiredDeltas, PairList<String, Long> inputDeltas, PairList<String, Long> virtualStores, long earliestScheduleTimestamp, int retryCount) {
        Preconditions.checkNotNull((Object)job, (Object)"Scheduled job must have a job.");
        this.id = id;
        this.job = job;
        if (inputDeltas != null) {
            this.inputDeltas.addAll(inputDeltas);
        }
        if (virtualStores != null) {
            this.virtualStores.addAll(virtualStores);
        }
        this.requiredDeltas = requiredDeltas == null ? new HashSet<String>() : new HashSet<String>(requiredDeltas);
        this.earliestScheduleTimestamp = earliestScheduleTimestamp;
        this.retryCount = retryCount;
    }

    public static ScheduledJob copyWithRescheduleUpdate(ScheduledJob job, long earliestScheduleTimestamp, int retryCount) {
        return new ScheduledJob(job.id, job.job, job.requiredDeltas, job.inputDeltas, job.virtualStores, earliestScheduleTimestamp, retryCount);
    }

    public JobDescriptor getJob() {
        return this.job;
    }

    public CommitDescriptor getSchedulingCommit() {
        return this.job.getSchedulingCommit();
    }

    public UnmodifiableSet<String> getRequiredDeltas() {
        return CollectionUtils.asUnmodifiable(this.requiredDeltas);
    }

    public InternalProjectId getProjectId() {
        return this.job.getInternalProjectId();
    }

    public String getTriggerName() {
        return this.job.getTriggerName();
    }

    public List<Long> getInputDeltaIdsForStore(String storeName) {
        return this.inputDeltas.extractSecondElementsFilteredByFirst(storeName::equals);
    }

    public List<Long> getVirtualStoreIdsForStore(String storeName) {
        return this.virtualStores.extractSecondElementsFilteredByFirst(storeName::equals);
    }

    public List<String> getInputDeltaStoreNames() {
        return this.inputDeltas.extractFirstList();
    }

    public Collection<Long> getInputDeltaIds() {
        return this.inputDeltas.getSecondList();
    }

    public Collection<Long> getAllVirtualStoreIds() {
        return this.virtualStores.getSecondList();
    }

    public PairList<String, Long> getInputDeltas() {
        return new PairList(this.inputDeltas);
    }

    public PairList<String, Long> getVirtualStores() {
        return new PairList(this.virtualStores);
    }

    public long getEarliestScheduleTimestamp() {
        return this.earliestScheduleTimestamp;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String toString() {
        return this.id + ":" + String.valueOf(this.job);
    }

    public boolean equals(Object other) {
        return other instanceof ScheduledJob && ((ScheduledJob)other).id == this.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public ScheduledJob extendInputDeltaAndVirtualStore(long newJobId, String store, long deltaId, @Nullable Long virtualStoreId) {
        ScheduledJob extendedJob = new ScheduledJob(newJobId, this.job, this.requiredDeltas);
        extendedJob.inputDeltas.addAll(this.inputDeltas);
        extendedJob.inputDeltas.add((Object)store, (Object)deltaId);
        extendedJob.virtualStores.addAll(this.virtualStores);
        if (virtualStoreId != null) {
            extendedJob.virtualStores.add((Object)store, (Object)virtualStoreId);
        }
        return extendedJob;
    }
}

