/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ESchedulerCommand;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import java.io.Serializable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jspecify.annotations.Nullable;

class SchedulerCommunicator
implements ISchedulerCommunicator {
    private static final String SEPARATOR = ":";
    public static final String COMMAND_CHANNEL = "scheduler-commands";

    @Override
    public void sendReloadCommand(IMessageBroker messageBroker, InternalProjectId projectId) {
        SchedulerCommunicator.sendSchedulerCommand(messageBroker, projectId, ESchedulerCommand.RELOAD.name());
    }

    @Override
    public void sendSetJobReadyCommand(IMessageBroker messageBroker, InternalProjectId projectId, CommitDescriptor commitDescriptor, String triggerName) {
        SchedulerCommunicator.sendSchedulerCommand(messageBroker, projectId, ESchedulerCommand.SET_JOB_READY.name() + SEPARATOR + triggerName + SEPARATOR + String.valueOf(commitDescriptor));
    }

    private static void sendSchedulerCommand(IMessageBroker messageBroker, InternalProjectId projectId, String message) {
        if (projectId != null) {
            message = (String)message + SEPARATOR + String.valueOf(projectId);
        }
        messageBroker.sendMessage(COMMAND_CHANNEL, (String)message);
    }

    @Override
    public void scheduleExternalJob(IndexLayer indexLayer, JobDescriptor job) throws StorageException {
        AnalysisProgressIndexBase progressIndex = AnalysisProgressIndexBase.open(indexLayer, (IProjectId)job.getInternalProjectId());
        IMessageBroker messageBroker = indexLayer.getMessageBroker();
        this.scheduleExternalJob(progressIndex, messageBroker, job);
    }

    @Override
    public void scheduleExternalJob(AnalysisProgressIndexBase progressIndex, IMessageBroker messageBroker, JobDescriptor job) throws StorageException {
        progressIndex.createExternallyScheduledJobsSet(job.getInternalProjectId(), messageBroker).add((Serializable)job);
    }

    @Override
    public void scheduleExternallyStartedTrigger(IndexLayer indexLayer, InternalProjectId projectId, String triggerName) throws StorageException {
        AnalysisProgressIndexBase progressIndex = AnalysisProgressIndexBase.open(indexLayer, (IProjectId)projectId);
        IMessageBroker messageBroker = indexLayer.getMessageBroker();
        progressIndex.createExternallyScheduledTriggersSet(projectId, messageBroker).add((Serializable)((Object)triggerName));
    }

    @Override
    public void scheduleExternallyStartedTrigger(IndexLayer indexLayer, InternalProjectId projectId, Class<? extends AnalysisStepBase> triggerClass) throws StorageException {
        this.scheduleExternallyStartedTrigger(indexLayer, projectId, TriggerBuilder.getSimpleTriggerName(triggerClass));
    }

    @Override
    public void scheduleMaintenanceTrigger(Class<? extends MaintenanceTriggerBase> triggerClass, String schedulingReason, IndexLayer indexLayer) throws StorageException {
        this.scheduleMaintenanceTrigger(triggerClass, null, schedulingReason, indexLayer);
    }

    @Override
    public void scheduleMaintenanceTrigger(Class<? extends MaintenanceTriggerBase> triggerClass, String parameter, String schedulingReason, IndexLayer indexLayer) throws StorageException {
        JobDescriptor job = new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, triggerClass, null, (Object)parameter, schedulingReason);
        this.scheduleExternalJob(indexLayer, job);
    }

    public static Pair<ESchedulerCommand, @Nullable Object> parseSchedulerCommand(String rawMessage) {
        String[] parts = rawMessage.split(SEPARATOR);
        ESchedulerCommand command = (ESchedulerCommand)EnumUtils.valueOf(ESchedulerCommand.class, (String)parts[0]);
        CCSMAssert.isNotNull((Object)((Object)command), (String)("Invalid scheduler command " + parts[0]));
        return Pair.createPair((Object)((Object)command), (Object)(switch (command) {
            default -> throw new MatchException(null, null);
            case ESchedulerCommand.RELOAD -> SchedulerCommunicator.parseReloadCommandParameter(parts);
            case ESchedulerCommand.SET_JOB_READY -> SchedulerCommunicator.parseSetJobReadyParameters(parts);
        }));
    }

    private static @Nullable String parseReloadCommandParameter(String[] parts) {
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    private static SchedulingData.SetJobReadyParameters parseSetJobReadyParameters(String[] parts) {
        int numExpectedArguments = 4;
        CCSMAssert.isTrue((parts.length == numExpectedArguments ? 1 : 0) != 0, () -> String.format("Expected only %s parts, but received [%s].", numExpectedArguments + 1, String.join((CharSequence)", ", parts)));
        return new SchedulingData.SetJobReadyParameters(new InternalProjectId(parts[3]), CommitDescriptor.fromStringRepresentation((String)parts[2]), parts[1]);
    }
}

