/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.shutdown;

import com.teamscale.core.shutdown.ShutdownManager;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ShutdownLock {
    private boolean inNoShutdownRegion = false;

    ShutdownLock() {
    }

    public synchronized boolean enterNoShutdownRegion() {
        CCSMAssert.isFalse((boolean)this.inNoShutdownRegion, (String)"May not enter no-shutdown region twice.");
        if (ShutdownManager.getInstance().isShutdownStarted()) {
            return false;
        }
        this.inNoShutdownRegion = true;
        return true;
    }

    public synchronized void exitNoShutdownRegion() {
        CCSMAssert.isTrue((boolean)this.inNoShutdownRegion, (String)"May not exit no-shutdown region without entering it.");
        this.inNoShutdownRegion = false;
    }

    public synchronized boolean isInNoShutdownRegion() {
        return this.inNoShutdownRegion;
    }
}

