/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import java.util.List;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface ISubscriptionRestClient
extends IRetrofitApi {
    @GET(value="_apis/hooks/subscriptions?api-version=5.0")
    public Subscriptions getSubscriptions() throws ServiceCallException;

    @POST(value="_apis/hooks/subscriptions?api-version=5.0")
    @Headers(value={"Content-Type: application/json"})
    public Subscription createSubscription(@Body Subscription var1) throws ServiceCallException;

    @PUT(value="_apis/hooks/subscriptions/{subscriptionId}?api-version=5.0")
    @Headers(value={"Content-Type: application/json"})
    public Subscription replaceSubscription(@Path(value="subscriptionId") String var1, @Body Subscription var2) throws ServiceCallException;

    public static class ConsumerInputs {
        @JsonProperty(value="url")
        public final String url;

        @JsonCreator
        public ConsumerInputs(@JsonProperty(value="url") String url) {
            this.url = url;
        }
    }

    public static class PublisherInputs {
        @JsonProperty(value="repository")
        public final String repositoryId;
        @JsonProperty(value="projectId")
        public final String projectId;

        @JsonCreator
        public PublisherInputs(@JsonProperty(value="repository") String repositoryId, @JsonProperty(value="projectId") String projectId) {
            this.repositoryId = repositoryId;
            this.projectId = projectId;
        }
    }

    public static class Subscription {
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="status")
        public final String status;
        @JsonProperty(value="publisherId")
        public final String publisherId;
        @JsonProperty(value="eventType")
        public final String eventType;
        @JsonProperty(value="resourceVersion")
        public final String resourceVersion;
        @JsonProperty(value="consumerId")
        public final String consumerId;
        @JsonProperty(value="consumerActionId")
        public final String consumerActionId;
        @JsonProperty(value="publisherInputs")
        public final PublisherInputs publisherInputs;
        @JsonProperty(value="consumerInputs")
        public final ConsumerInputs consumerInputs;

        @JsonCreator
        public Subscription(@JsonProperty(value="status") String status, @JsonProperty(value="publisherId") String publisherId, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="resourceVersion") String resourceVersion, @JsonProperty(value="consumerId") String consumerId, @JsonProperty(value="consumerActionId") String consumerActionId, @JsonProperty(value="publisherInputs") PublisherInputs publisherInputs, @JsonProperty(value="consumerInputs") ConsumerInputs consumerInputs) {
            this.status = status;
            this.publisherId = publisherId;
            this.eventType = eventType;
            this.resourceVersion = resourceVersion;
            this.consumerId = consumerId;
            this.consumerActionId = consumerActionId;
            this.publisherInputs = publisherInputs;
            this.consumerInputs = consumerInputs;
        }

        public boolean isEnabled() {
            return "enabled".equals(this.status);
        }
    }

    public static class Subscriptions {
        @JsonProperty(value="value")
        private List<Subscription> values;

        public List<Subscription> getValues() {
            return this.values;
        }
    }
}

