/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class TfsWorkItem {
    public static final String TAGS_FIELD = "System.Tags";
    public static final String AREA_PATH = "System.AreaPath";
    public static final String ITERATION_PATH = "System.IterationPath";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendLiteral('.').appendFraction(ChronoField.MICRO_OF_SECOND, 1, 3, false).optionalEnd().appendZoneId().toFormatter();
    private static final String WORK_ITEM_URL_PART = "/_workitems/edit/";
    public static final String PARENT_RELATION_TYPE = "System.LinkTypes.Hierarchy-Reverse";
    private static final long MISSING_DATE_TIMESTAMP = 0L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="rev")
    private int revision;
    @JsonProperty(value="fields")
    private Map<String, String> fields;
    @JsonProperty(value="relations")
    private @Nullable List<Relation> relations;

    @JsonCreator
    public TfsWorkItem(@JsonProperty(value="id") String id, @JsonProperty(value="rev") int revision, @JsonProperty(value="fields") Map<String, String> fields, @JsonProperty(value="relations") List<Relation> relations) {
        this.id = id;
        this.revision = revision;
        this.fields = fields;
        this.relations = relations;
    }

    @VisibleForTesting
    public TfsWorkItem() {
    }

    public String getId() {
        return this.id;
    }

    public String createWorkItemLink(String url) {
        return StringUtils.ensureEndsWith((String)url, (String)"/") + this.getProjectName() + WORK_ITEM_URL_PART + this.id;
    }

    public String getTitle() {
        return this.fields.get("System.Title");
    }

    public String getDescriptionOrStepsToReproduce() {
        String description = this.fields.get("System.Description");
        if (StringUtils.isEmpty((String)description) && this.fields.containsKey("Microsoft.VSTS.TCM.ReproSteps")) {
            description = this.fields.get("Microsoft.VSTS.TCM.ReproSteps");
        }
        return description;
    }

    public String getStatus() {
        return this.fields.get("System.State");
    }

    public String getAssignee() {
        return this.fields.get("System.AssignedTo");
    }

    public String getAuthor() {
        return this.fields.get("System.CreatedBy");
    }

    public long getCreatedTimestamp() {
        String date = this.fields.get("System.CreatedDate");
        if (date == null) {
            return 0L;
        }
        return TfsWorkItem.convertDateTimeStringToTimestamp(date);
    }

    public long getUpdatedOnTimestamp() {
        String date = this.fields.get("System.ChangedDate");
        if (date == null) {
            return 0L;
        }
        return TfsWorkItem.convertDateTimeStringToTimestamp(date);
    }

    @VisibleForTesting
    static long convertDateTimeStringToTimestamp(String date) {
        return ZonedDateTime.parse(date, DATE_TIME_FORMATTER).toInstant().toEpochMilli();
    }

    public String getProjectName() {
        return this.fields.get("System.TeamProject");
    }

    public String getChangedBy() {
        return this.fields.get("System.ChangedBy");
    }

    public int getRevisionNumber() {
        return this.revision;
    }

    public @Nullable String getParentId() {
        return this.getRelationsForType(PARENT_RELATION_TYPE).stream().findFirst().orElse(null);
    }

    public List<String> getRelationsForType(String type) {
        if (this.relations == null) {
            return Collections.emptyList();
        }
        return this.relations.stream().filter(relation -> relation.type.equals(type)).map(relation -> StringUtils.getLastPart((String)relation.url, (String)"/")).toList();
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String toString() {
        return "TfsWorkItem{id='" + this.id + "', revision=" + this.revision + ", fields=" + String.valueOf(this.fields) + ", relations=" + String.valueOf(this.relations) + "}";
    }

    private static class Relation {
        @JsonProperty(value="rel")
        private String type;
        @JsonProperty(value="url")
        private String url;

        private Relation() {
        }

        public String toString() {
            return "Relation{type='" + this.type + "', url='" + this.url + "'}";
        }
    }
}

