/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentMatches;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public abstract class CSVParserBase<RowType>
implements Iterable<RowType> {
    private List<RowType> data = null;
    private final Configuration configuration;

    public CSVParserBase(Configuration configuration) {
        this.configuration = configuration;
    }

    public void parseAndWrapExceptions(Reader inputReader) throws ConQATException {
        CCSMAssert.isTrue((this.data == null ? 1 : 0) != 0, (String)"You may not reuse this parser");
        this.data = new ArrayList<RowType>();
        try {
            this.parse(inputReader);
        }
        catch (IOException e) {
            throw new ConQATException("An IO error occurred while parsing the CSV file", (Throwable)e);
        }
    }

    private void parse(Reader inputReader) throws IOException, ConQATException {
        try (CsvListReader reader = new CsvListReader(inputReader, this.configuration.createPreference());){
            String[] header = reader.getHeader(true);
            if (header == null) {
                if (this.configuration.allowEmptyFiles) {
                    return;
                }
                throw new ConQATException("The CSV file did not contain a header row.");
            }
            this.processHeaderRow(header);
            List<String> row = this.readNextRow(reader);
            while (row != null) {
                this.data.add(this.mapRow(row));
                row = this.readNextRow(reader);
            }
        }
    }

    private List<String> readNextRow(CsvListReader reader) throws IOException {
        List row = reader.read();
        if (row == null || !this.configuration.convertNullToEmptyString) {
            return row;
        }
        ArrayList<String> convertedRow = new ArrayList<String>();
        for (String value : row) {
            if (value == null) {
                value = "";
            }
            convertedRow.add(value);
        }
        return convertedRow;
    }

    protected void processHeaderRow(String[] header) throws ConQATException {
    }

    protected abstract RowType mapRow(List<String> var1);

    @Override
    public Iterator<RowType> iterator() {
        this.assertDataWasParsed();
        return CollectionUtils.asUnmodifiable(this.data).iterator();
    }

    public Stream<RowType> stream() {
        this.assertDataWasParsed();
        return CollectionUtils.asUnmodifiable(this.data).stream();
    }

    protected void assertDataWasParsed() {
        CCSMAssert.isNotNull(this.data, (String)"You must call #parseAndWrapExceptions() before you can use this method");
    }

    public int getRowCount() {
        this.assertDataWasParsed();
        return this.data.size();
    }

    public static class Configuration {
        private char quoteChar = (char)34;
        private char delimiterChar = (char)59;
        private String endOfLineSymbols = "\r\n";
        private String commentLinePattern = null;
        protected boolean convertNullToEmptyString = true;
        protected boolean allowEmptyFiles = false;

        public Configuration setQuoteChar(char quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        public Configuration setConvertNullToEmptyString(boolean convertNullToEmptyString) {
            this.convertNullToEmptyString = convertNullToEmptyString;
            return this;
        }

        public Configuration setAllowEmptyFiles(boolean allowEmptyFiles) {
            this.allowEmptyFiles = allowEmptyFiles;
            return this;
        }

        public Configuration setDelimiterChar(char delimiterChar) {
            this.delimiterChar = delimiterChar;
            return this;
        }

        public Configuration setCommentLinePattern(String commentLinePattern) {
            this.commentLinePattern = commentLinePattern;
            return this;
        }

        public Configuration setEndOfLineSymbols(String endOfLineSymbols) {
            this.endOfLineSymbols = endOfLineSymbols;
            return this;
        }

        private CsvPreference createPreference() {
            CsvPreference.Builder builder = new CsvPreference.Builder(this.quoteChar, (int)this.delimiterChar, this.endOfLineSymbols);
            if (this.commentLinePattern != null) {
                builder.skipComments((CommentMatcher)new CommentMatches(this.commentLinePattern));
            }
            return builder.build();
        }
    }
}

