/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;

public class StoreWriteBuffer {
    private static final int MAXIMUM_SIZE_IN_MEGA_BYTES = 512;
    private final PairList<byte[], byte[]> buffer = new PairList();
    private final IStore store;

    public StoreWriteBuffer(IStore store) {
        this.store = store;
    }

    public void add(byte[] key, byte[] value) throws StorageException {
        this.buffer.add((Object)key, (Object)value);
        this.checkSizeAndFlushIfNecessary();
    }

    private void checkSizeAndFlushIfNecessary() throws StorageException {
        int totalValuesSizeInMegaBytes = this.buffer.stream().map(ImmutablePair::getSecond).mapToInt(values -> ((byte[])values).length).sum() / 0x100000;
        if (totalValuesSizeInMegaBytes > 512) {
            this.flush();
        }
    }

    public void flush() throws StorageException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.store.put(this.buffer);
        this.buffer.clear();
    }
}

