/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.fxcop;

import eu.cqse.check.framework.core.registry.CheckMapping;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.dotnet.fxcop.EFxCopAttribute;
import org.conqat.engine.dotnet.fxcop.EFxCopElement;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public class FxCopReportReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FxCopFindingsCreator findingsCreator;
    private final Map<String, CheckMapping> checkMappingsByName;

    public FxCopReportReader(FxCopFindingsCreator findingsCreator, Map<String, CheckMapping> checkMappingsByName) {
        this.checkMappingsByName = checkMappingsByName;
        this.findingsCreator = findingsCreator;
    }

    public void loadReport(String report) throws ConQATException {
        new FxCopFileReader(report).parse();
    }

    public static interface FxCopFindingsCreator {
        public void apply(String var1, String var2, String var3, String var4, String var5, int var6, String var7, String var8) throws ConQATException;
    }

    private class FxCopFileReader
    extends XMLReaderBase<EFxCopElement, EFxCopAttribute, ConQATException> {
        public FxCopFileReader(String report) {
            super(report, EFxCopAttribute.class);
        }

        public void parse() throws ConQATException {
            this.parseAndWrapExceptions();
            this.readExceptions();
            this.extractRules();
            this.createFindings();
        }

        private void extractRules() throws ConQATException {
            this.processDecendantElements(new RuleProcessor());
        }

        private void createFindings() throws ConQATException {
            this.processDecendantElements(new NamespaceProcessor());
        }

        private void readExceptions() throws ConQATException {
            this.processDecendantElements(new AnalysisExcpetionProcessor());
        }

        protected String getLocation() {
            return "FxCop Report";
        }

        private class RuleProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private RuleProcessor() {
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Rule;
            }

            public void process() {
                String typeName = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.TypeName);
                String description = FxCopFileReader.this.getChildText(EFxCopElement.Description);
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)typeName), (String)"The type name of the rule should not be empty");
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)description), (String)"The description of the rule should not be empty");
            }
        }

        private class NamespaceProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private NamespaceProcessor() {
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Namespace;
            }

            public void process() throws ConQATException {
                String namespaceName = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.Name);
                FxCopFileReader.this.processDecendantElements(new TypeProcessor(namespaceName));
            }
        }

        private class AnalysisExcpetionProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private AnalysisExcpetionProcessor() {
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Exception;
            }

            public void process() {
                Object message = FxCopFileReader.this.getChildText(EFxCopElement.ExceptionMessage);
                String innerMessage = FxCopFileReader.this.getChildText(EFxCopElement.InnerExceptionMessage);
                if (!StringUtils.isEmpty((String)innerMessage)) {
                    message = (String)message + StringUtils.LINE_SEPARATOR + innerMessage;
                }
                LOGGER.warn("FxCop threw an exception while writing " + UniformPathUtils.getElementName((String)UniformPathUtils.normalizeAllSeparators((String)FxCopFileReader.this.getLocation())) + StringUtils.LINE_SEPARATOR + (String)message);
            }
        }

        public class IssueProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String fxCopCheckId;
            private final String fxCopCheckName;
            private final String fqTypeName;

            public IssueProcessor(String fxCopCheckId, String fxCopCheckName, String fqTypeName) {
                this.fxCopCheckId = fxCopCheckId;
                this.fxCopCheckName = fxCopCheckName;
                this.fqTypeName = fqTypeName;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Issue;
            }

            public void process() throws ConQATException {
                String message = FxCopFileReader.this.getText();
                if (StringUtils.isEmpty((String)message)) {
                    message = "<missing message>";
                }
                String path = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.Path);
                String file = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.File);
                FxCopReportReader.this.findingsCreator.apply(message, path, file, this.fxCopCheckName, this.fqTypeName, this.getLineNumber(), this.fxCopCheckId, this.fxCopCheckName);
            }

            private int getLineNumber() {
                String lineAsString = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.Line);
                if (StringUtils.isEmpty((String)lineAsString)) {
                    return 0;
                }
                try {
                    return Integer.parseInt(lineAsString);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Error parsing line for finding at " + lineAsString);
                    return -1;
                }
            }
        }

        public class MessageProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String fqTypeName;

            public MessageProcessor(String fqTypeNme) {
                this.fqTypeName = fqTypeNme;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Message;
            }

            public void process() throws ConQATException {
                String fxCopCheckId = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.CheckId);
                Optional<String> fxCopCheckName = FxCopReportReader.this.checkMappingsByName.keySet().stream().filter(checkName -> checkName.contains(fxCopCheckId)).findAny();
                CCSMAssert.isTrue((boolean)fxCopCheckName.isPresent(), (String)(String.valueOf((Object)EFxCopAttribute.TypeName) + "must not be empty"));
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)fxCopCheckId), (String)(String.valueOf((Object)EFxCopAttribute.CheckId) + "must not be empty"));
                FxCopFileReader.this.processChildElements(new IssueProcessor(fxCopCheckId, fxCopCheckName.get(), this.fqTypeName));
            }
        }

        private class TypeProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String namespaceName;

            public TypeProcessor(String namespaceName) {
                this.namespaceName = namespaceName;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Type;
            }

            public void process() throws ConQATException {
                Object typeName = FxCopFileReader.this.getStringAttribute(EFxCopAttribute.Name);
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)typeName), (String)"Type name not set");
                if (!StringUtils.isEmpty((String)this.namespaceName)) {
                    typeName = this.namespaceName + "." + (String)typeName;
                }
                FxCopFileReader.this.processDecendantElements(new MessageProcessor((String)typeName));
            }
        }
    }
}

