/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;

public class LlvmCoverageReportParser
extends CoverageReportParserBase {
    private static final String LLVM_COVERAGE_TYPE = "llvm.coverage.json.export";

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        try {
            LlvmCoverageJsonVersionAndType versionAndType = (LlvmCoverageJsonVersionAndType)JsonUtils.deserializeFromJsonWithNullCheck((String)report, LlvmCoverageJsonVersionAndType.class);
            ELlvmCoverageReportVersion version = LlvmCoverageReportParser.checkTypeAndVersion(versionAndType);
            switch (version.ordinal()) {
                case 0: 
                case 1: {
                    LlvmCoverageReportParser.parseVersion2Report(report, retriever);
                    break;
                }
                default: {
                    throw new ReportParserException("Unsupported LLVM report format version: " + version.getVersionString());
                }
            }
        }
        catch (JsonSerializationException e) {
            throw new ReportParserException("Unable to parse LLVM Coverage JSON report", e);
        }
    }

    private static ELlvmCoverageReportVersion checkTypeAndVersion(LlvmCoverageJsonVersionAndType typeAndVersion) throws ReportParserException {
        if (!LLVM_COVERAGE_TYPE.equals(typeAndVersion.type)) {
            throw new ReportParserException("Unsupported LLVM Coverage Report Type: " + typeAndVersion.type + ". Expected 'llvm.coverage.json.export'.");
        }
        for (ELlvmCoverageReportVersion version : ELlvmCoverageReportVersion.values()) {
            if (!version.getVersionString().equals(typeAndVersion.version)) continue;
            return version;
        }
        String supportedVersions = Arrays.stream(ELlvmCoverageReportVersion.values()).map(ELlvmCoverageReportVersion::getVersionString).collect(Collectors.joining(", "));
        throw new ReportParserException("Unsupported LLVM Coverage Report Version: " + typeAndVersion.version + ". Supported: " + supportedVersions);
    }

    private static void parseVersion2Report(String report, CoverageInfoRetriever retriever) throws JsonSerializationException {
        LlvmCoverageJson json = (LlvmCoverageJson)JsonUtils.deserializeFromJsonWithNullCheck((String)report, LlvmCoverageJson.class);
        for (LlvmCoverageData coverageData : json.data) {
            LlvmCoverageReportParser.parseCoverageData(coverageData, retriever);
        }
    }

    private static void parseCoverageData(LlvmCoverageData data, CoverageInfoRetriever retriever) {
        for (LlvmFileCoverage fileCoverage : data.coveragePerFile) {
            LineCoverageInfo coverageInfo = retriever.getOrCreateLineCoverageInfo(fileCoverage.filename);
            LlvmCoverageReportParser.parseFileCoverage(fileCoverage, coverageInfo);
        }
    }

    private static void parseFileCoverage(LlvmFileCoverage fileCoverage, LineCoverageInfo lineCoverageInfo) {
        Set<Integer> processedLines = LlvmCoverageReportParser.parseBranchCoverageInformation(fileCoverage, lineCoverageInfo);
        LlvmCoverageReportParser.parseSegmentCoverageInfo(fileCoverage, lineCoverageInfo, processedLines);
    }

    private static Set<Integer> parseBranchCoverageInformation(LlvmFileCoverage fileCoverage, LineCoverageInfo lineCoverageInfo) {
        if (fileCoverage.branches == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> processedLines = new HashSet<Integer>();
        for (LlvmBranchInformation branch : fileCoverage.branches) {
            for (int line = branch.lineStart; line <= branch.lineEnd; ++line) {
                ELineCoverage coverage = branch.executionCount > 0L && branch.falseExecutionCount > 0L ? ELineCoverage.FULLY_COVERED : (branch.executionCount == 0L && branch.falseExecutionCount == 0L ? ELineCoverage.NOT_COVERED : ELineCoverage.PARTIALLY_COVERED);
                processedLines.add(line);
                lineCoverageInfo.addLineCoverage(line, coverage);
            }
        }
        return processedLines;
    }

    private static void parseSegmentCoverageInfo(LlvmFileCoverage fileCoverage, LineCoverageInfo lineCoverageInfo, Set<Integer> processedLines) {
        for (int i = 0; i < fileCoverage.segments.size() - 1; ++i) {
            LlvmCoverageSegment currentSegment = fileCoverage.segments.get(i);
            if (!currentSegment.hasCount) continue;
            LlvmCoverageSegment nextSegment = fileCoverage.segments.get(i + 1);
            int startLine = currentSegment.line;
            int endLine = nextSegment.line;
            if (!currentSegment.isRegionEntry && startLine == endLine) continue;
            if (!currentSegment.isRegionEntry && startLine < endLine) {
                ++startLine;
            }
            IntStream segmentLines = nextSegment.col == 1 ? IntStream.range(startLine, endLine) : IntStream.rangeClosed(startLine, endLine);
            ELineCoverage howCovered = ELineCoverage.FULLY_COVERED;
            if (currentSegment.count < 1L) {
                howCovered = ELineCoverage.NOT_COVERED;
            }
            lineCoverageInfo.addLineCoverage(segmentLines.filter(line -> !processedLines.contains(line)), howCovered);
        }
    }

    private static class LlvmCoverageJsonVersionAndType {
        private String version;
        private String type;

        private LlvmCoverageJsonVersionAndType() {
        }
    }

    private static enum ELlvmCoverageReportVersion {
        VERSION_2_0_0("2.0.0"),
        VERSION_2_0_1("2.0.1");

        private final String versionString;

        private ELlvmCoverageReportVersion(String versionString) {
            this.versionString = versionString;
        }

        public String getVersionString() {
            return this.versionString;
        }
    }

    private static class LlvmCoverageJson {
        private List<LlvmCoverageData> data;

        private LlvmCoverageJson() {
        }
    }

    private static class LlvmCoverageData {
        @JsonProperty(value="files")
        private List<LlvmFileCoverage> coveragePerFile;

        private LlvmCoverageData() {
        }
    }

    private static class LlvmFileCoverage {
        private String filename;
        private final List<LlvmCoverageSegment> segments = new ArrayList<LlvmCoverageSegment>();
        private final List<LlvmBranchInformation> branches = new ArrayList<LlvmBranchInformation>();

        private LlvmFileCoverage() {
        }
    }

    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    private static class LlvmBranchInformation {
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int lineStart;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int columnStart;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int lineEnd;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int columnEnd;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private long executionCount;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private long falseExecutionCount;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int fileId;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int expandedFileId;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int kind;

        private LlvmBranchInformation() {
        }
    }

    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    private static class LlvmCoverageSegment {
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int line;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private int col;
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        private long count;
        @JsonFormat(shape=JsonFormat.Shape.BOOLEAN)
        private boolean hasCount;
        @JsonFormat(shape=JsonFormat.Shape.BOOLEAN)
        private boolean isRegionEntry;
        @JsonFormat(shape=JsonFormat.Shape.BOOLEAN)
        private boolean isGapRegion;

        private LlvmCoverageSegment() {
        }
    }
}

