/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.cobertura;

import com.teamscale.reportparser.parser.cobertura.CoberturaReportHandlerBase;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.xml.sax.Attributes;

public class CoberturaReportHandler
extends CoberturaReportHandlerBase {
    private final CoverageInfoRetriever lineCoverageInfoRetriever;
    private LineCoverageInfo currentLineCoverage;
    private boolean inMethods = false;

    public CoberturaReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "class": {
                this.currentLineCoverage = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(attributes.getValue("filename"));
                break;
            }
            case "methods": {
                this.inMethods = true;
                break;
            }
            case "line": {
                if (this.inMethods) break;
                this.updateLineCoverage(attributes);
                break;
            }
        }
    }

    private void updateLineCoverage(Attributes attributes) {
        int lineNumber = Integer.parseInt(attributes.getValue("number"));
        long hits = Long.parseLong(attributes.getValue("hits"));
        if (hits == 0L) {
            this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.NOT_COVERED);
            return;
        }
        boolean branch = Boolean.parseBoolean(attributes.getValue("branch"));
        if (!branch) {
            this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.FULLY_COVERED);
        } else {
            String conditionCoverage = attributes.getValue("condition-coverage");
            if (conditionCoverage == null || conditionCoverage.contains("100%")) {
                this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.FULLY_COVERED);
            } else {
                this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.PARTIALLY_COVERED);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("methods")) {
            this.inMethods = false;
        }
    }
}

