/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.ctc;

import com.teamscale.reportparser.parser.ctc.CtcReportHelper;
import com.teamscale.reportparser.parser.ctc.InvalidCtcCoverageFileException;
import com.teamscale.reportparser.parser.ctc.ProbeInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.engine.sourcecode.coverage.DecisionProbe;
import org.conqat.engine.sourcecode.coverage.DecisionProbeConfiguration;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.McDcCondition;
import org.conqat.engine.sourcecode.coverage.SimpleStatementCoverageProbe;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class CtcReportHandler
extends DefaultHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern LINEDIR_PATTERN = Pattern.compile("#line\\s+\\d+\\s+\"(.*)\"", 2);
    private final CoverageInfoRetriever coverageInfoRetriever;
    private LineCoverageInfo currentLineCoverage;
    private final Stack<ProbeInfo> probeStack = new Stack();
    private final Set<Integer> processedLines = new HashSet<Integer>();
    private final Map<Integer, ProbeInfo> branchedProbeInfoWithNestingInformation = new HashMap<Integer, ProbeInfo>();
    private String currentSourceFileName;
    private String methodName;
    private final String coverageReportLocation;
    private final Map<Integer, CoverageProbeBase> coverageProbesByLine = new HashMap<Integer, CoverageProbeBase>();

    public CtcReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever, String coverageReportLocation) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.coverageInfoRetriever = lineCoverageInfoRetriever;
        this.coverageReportLocation = coverageReportLocation;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws InvalidCtcCoverageFileException {
        switch (qName) {
            case "file": {
                this.switchSourceFile(attributes.getValue("name"));
                break;
            }
            case "function": {
                this.branchedProbeInfoWithNestingInformation.clear();
                this.methodName = attributes.getValue("name");
                this.assertEmptyProbeStack();
                break;
            }
            case "probe": {
                this.processProbeElement(attributes);
                break;
            }
        }
    }

    private void assertEmptyProbeStack() throws AssertionError {
        CCSMAssert.isTrue((boolean)this.probeStack.isEmpty(), (String)String.format("For [Report File = %s, Source File Name = %s, Method Name = %s] branch construct stack [%s] must be empty. ", this.coverageReportLocation, this.currentSourceFileName, this.methodName, this.probeStack));
    }

    private void switchSourceFile(String fileName) {
        this.currentSourceFileName = fileName;
        this.currentLineCoverage = this.coverageInfoRetriever.getOrCreateLineCoverageInfo(this.currentSourceFileName);
        this.processedLines.clear();
        this.coverageProbesByLine.clear();
    }

    private void processProbeElement(Attributes attributes) throws InvalidCtcCoverageFileException {
        if (this.handleSourceSwitch(attributes)) {
            return;
        }
        this.processProbeForProbeBasedCoverage(attributes);
        ProbeInfo currentProbeInfo = this.createProbeInfo(attributes);
        if (currentProbeInfo == null) {
            return;
        }
        String probeType = currentProbeInfo.getType();
        if (CtcReportHelper.isCaseOrCaseDefault(probeType) && CtcReportHelper.isCaseOrCaseDefault(this.probeStack.peek().getType()) && currentProbeInfo.getExecutedWithTrueValue() == ProbeInfo.EExecutionInfo.NOT_EXECUTED) {
            return;
        }
        if (this.isBlockEndProbeType(probeType)) {
            this.processBlockEndProbeType(currentProbeInfo);
        } else if (CtcReportHelper.isNoEndBlockConstruct(currentProbeInfo)) {
            this.updateLineCoverage(currentProbeInfo.getLineNumber(), this.determineLineCoverage(currentProbeInfo));
        } else {
            this.probeStack.push(currentProbeInfo);
        }
    }

    private boolean handleSourceSwitch(Attributes attributes) {
        if ("linedir_in_function".equalsIgnoreCase(attributes.getValue("type"))) {
            this.switchSourceFileForLineDirProbe(attributes);
            return true;
        }
        if ("linedir".equalsIgnoreCase(attributes.getValue("type"))) {
            this.assertEmptyProbeStack();
            this.switchSourceFileForLineDirProbe(attributes);
            return true;
        }
        return false;
    }

    private void switchSourceFileForLineDirProbe(Attributes attributes) {
        String description = attributes.getValue("descr");
        Matcher matcher = LINEDIR_PATTERN.matcher(description);
        if (matcher.matches()) {
            this.switchSourceFile(matcher.group(1));
        } else {
            LOGGER.error("Found linedir probe with unsupported pattern: {}", (Object)description);
        }
    }

    private void processProbeForProbeBasedCoverage(Attributes attributes) {
        SimpleStatementCoverageProbe probe = null;
        int lineNumber = CtcReportHelper.toInt(attributes.getValue("line"), -1);
        String probeType = attributes.getValue("type");
        switch (probeType = CtcReportHelper.removeConstPrefix(probeType)) {
            case "function": 
            case "lambda": 
            case "return": {
                int executionCount = CtcReportHelper.getExecutionCounter1(attributes);
                probe = new SimpleStatementCoverageProbe(lineNumber, executionCount);
                break;
            }
            case "if": 
            case "for": 
            case "else_if": 
            case "while": 
            case "do": 
            case "expr_andor": {
                int trueExecutionCount = CtcReportHelper.getExecutionCounter1(attributes);
                int falseExecutionCount = CtcReportHelper.getExecutionCounter2(attributes);
                probe = new DecisionProbe(lineNumber, trueExecutionCount, falseExecutionCount);
                break;
            }
            case "mcdc": {
                this.processMcDcProbe(attributes, lineNumber);
                break;
            }
            default: {
                if (!probeType.startsWith("multi_cond_")) break;
                this.processMultiConditionProbe(attributes, lineNumber, probeType);
            }
        }
        if (probe != null) {
            this.coverageInfoRetriever.getOrCreateProbeCoverageInfo(this.currentSourceFileName).addProbe((CoverageProbeBase)probe);
            this.coverageProbesByLine.put(probe.getLine(), (CoverageProbeBase)probe);
        }
    }

    private void processMultiConditionProbe(Attributes attributes, int lineNumber, String probeType) {
        DecisionProbe decisionProbe = this.getDecisionProbe(lineNumber);
        if (decisionProbe != null) {
            boolean decisionValue = "t".equals(StringUtils.stripPrefix((String)probeType, (String)"multi_cond_"));
            String description = attributes.getValue("descr");
            int executionCount = decisionValue ? CtcReportHelper.getExecutionCounter1(attributes) : CtcReportHelper.getExecutionCounter2(attributes);
            decisionProbe.addConfiguration(new DecisionProbeConfiguration(decisionValue, executionCount, description));
        }
    }

    private void processMcDcProbe(Attributes attributes, int lineNumber) {
        DecisionProbe decisionProbe = this.getDecisionProbe(lineNumber);
        if (decisionProbe != null) {
            boolean fulfilled = CtcReportHelper.toInt(attributes.getValue("alarmed"), 0) == 0;
            String description = attributes.getValue("descr");
            decisionProbe.addCondition(new McDcCondition(fulfilled, description));
        }
    }

    private DecisionProbe getDecisionProbe(int lineNumber) {
        CoverageProbeBase decisionProbe = this.coverageProbesByLine.get(lineNumber);
        if (!(decisionProbe instanceof DecisionProbe)) {
            LOGGER.error("Expected decision probe for line {} for {} > {} but was: {}", (Object)lineNumber, (Object)this.currentSourceFileName, (Object)this.methodName, (Object)decisionProbe);
            return null;
        }
        return (DecisionProbe)decisionProbe;
    }

    private ProbeInfo createProbeInfo(Attributes attributes) throws InvalidCtcCoverageFileException {
        String probeType = attributes.getValue("type");
        if (CtcReportHelper.isIgnoredProbeType(probeType = CtcReportHelper.removeConstPrefix(probeType))) {
            return null;
        }
        ProbeInfo.EExecutionInfo executedWithTrueValue = CtcReportHelper.getExecutionInfoFromAttribute(attributes, "count1");
        ProbeInfo.EExecutionInfo executedWithFalseValue = CtcReportHelper.getExecutionInfoFromAttribute(attributes, "count2");
        String message = "For [Report File = %s, Source File Name = %s, Method Name = %s, Probe Type = %s] %s information is not provided.";
        int lineNumber = CtcReportHelper.toInt(attributes.getValue("line"), -1);
        CtcReportHelper.validateIntegerAttribute(String.format(message, this.coverageReportLocation, this.currentSourceFileName, this.methodName, probeType, "The line number"), lineNumber);
        int nestingDepth = CtcReportHelper.toInt(attributes.getValue("nesting"), -1);
        CtcReportHelper.validateIntegerAttribute(String.format(message, this.coverageReportLocation, this.currentSourceFileName, this.methodName, probeType, "The nesting depth"), nestingDepth);
        if (CtcReportHelper.isReturnOrBreak(probeType) && this.isCaseWithBreakOrReturn(probeType) && nestingDepth == this.probeStack.peek().getNestingDepth() + 1) {
            --nestingDepth;
        }
        return new ProbeInfo(executedWithTrueValue, executedWithFalseValue, lineNumber, nestingDepth, probeType);
    }

    private boolean isCaseWithBreakOrReturn(String probeType) {
        return CtcReportHelper.isReturnOrBreak(probeType) && CtcReportHelper.isCaseOrCaseDefault(this.probeStack.peek().getType());
    }

    private void processBlockEndProbeType(ProbeInfo probeInfo) {
        if (!this.probeInStackHasAtLeastSameNestingDepth(probeInfo)) {
            return;
        }
        ProbeInfo stackedProbeInfo = this.probeStack.pop();
        if (CtcReportHelper.isBranch(stackedProbeInfo.getType())) {
            this.branchedProbeInfoWithNestingInformation.put(stackedProbeInfo.getNestingDepth(), stackedProbeInfo);
        }
        ELineCoverage coverage = null;
        if (CtcReportHelper.isIfOrElseIf(stackedProbeInfo.getType())) {
            coverage = CtcReportHelper.determineLineCoverageForLoopAndBranchConstruct(stackedProbeInfo.getExecutedWithTrueValue(), stackedProbeInfo.getExecutedWithFalseValue(), stackedProbeInfo.getType());
            this.updateLineCoverage(stackedProbeInfo.getLineNumber(), coverage);
        }
        coverage = this.determineLineCoverage(stackedProbeInfo);
        for (int i = stackedProbeInfo.getLineNumber(); i <= probeInfo.getLineNumber(); ++i) {
            this.updateLineCoverage(i, coverage);
        }
        this.processBlockEndProbeType(probeInfo);
    }

    private boolean probeInStackHasAtLeastSameNestingDepth(ProbeInfo probeInfo) {
        if (this.probeStack.isEmpty()) {
            return false;
        }
        return this.probeStack.peek().getNestingDepth() >= probeInfo.getNestingDepth();
    }

    private ELineCoverage determineLinecoverageForElseConstruct(ProbeInfo stackedProbeInfo) {
        ProbeInfo branchedProbeInfo = this.branchedProbeInfoWithNestingInformation.get(stackedProbeInfo.getNestingDepth());
        if (branchedProbeInfo == null) {
            LOGGER.info("Missing branch probe for 'if' statement for {} in {}. This can happen due to skipped 'if' part. Coverage will be missing.", (Object)stackedProbeInfo, (Object)this.currentSourceFileName);
            return ELineCoverage.NOT_COVERED;
        }
        if (branchedProbeInfo.getExecutedWithFalseValue() == ProbeInfo.EExecutionInfo.EXECUTED) {
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }

    private boolean isBlockEndProbeType(String probeType) {
        if (this.probeStack.isEmpty()) {
            return false;
        }
        return "block_end".equalsIgnoreCase(probeType) || this.isCaseWithBreakOrReturn(probeType) || probeType.startsWith("function_end") || probeType.equals("lambda_end") || probeType.equals("lambda_end_nr");
    }

    private void updateLineCoverage(int line, ELineCoverage coverage) {
        CCSMAssert.isNotNull((Object)coverage, (String)String.format("The line coverage information [%s] must not be null.", coverage));
        if (this.processedLines.contains(line)) {
            return;
        }
        this.currentLineCoverage.addLineCoverage(line, coverage);
        this.processedLines.add(line);
    }

    private ELineCoverage determineLineCoverage(ProbeInfo stackedProbeInfo) {
        String probeType = stackedProbeInfo.getType();
        if (CtcReportHelper.isElse(probeType)) {
            return this.determineLinecoverageForElseConstruct(stackedProbeInfo);
        }
        if (CtcReportHelper.isTernary(probeType)) {
            return CtcReportHelper.determineLineCoverageForLoopAndBranchConstruct(stackedProbeInfo.getExecutedWithTrueValue(), stackedProbeInfo.getExecutedWithFalseValue(), probeType);
        }
        ProbeInfo.EExecutionInfo executedWithTrueValue = stackedProbeInfo.getExecutedWithTrueValue();
        if (executedWithTrueValue == ProbeInfo.EExecutionInfo.NOT_EXECUTED) {
            return ELineCoverage.NOT_COVERED;
        }
        return ELineCoverage.FULLY_COVERED;
    }
}

