/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.lcov;

import com.teamscale.reportparser.parser.ReportParserException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;

public class LcovReportHandler {
    private static final String INVALID_EXECUTION_COUNT_EXPLANATION = "This indicates memory corruption in the tested application. As a conservative strategy the execution count will be set to 0. Any other execution counts may be corrupted as well and consequently the contained coverage may not represent the actual coverage.";
    private static final Logger LOGGER = LogManager.getLogger((String)LcovReportHandler.class.getName());
    private static final String SF = "SF:";
    private static final int SF_LENGTH = "SF:".length();
    private static final String DA = "DA:";
    private static final int DA_LENGTH = "DA:".length();
    private static final String BRDA = "BRDA:";
    private static final int BRDA_LENGTH = "BRDA:".length();
    private static final String END_OF_RECORD = "end_of_record";
    private final CoverageInfoRetriever lineCoverageInfoRetriever;
    private String currentFile = null;
    private final CounterSet<Integer> lineToBranchesTaken = new CounterSet();
    private final CounterSet<Integer> lineToBranchesNotTaken = new CounterSet();
    private final Map<Integer, Long> lineToExecutions = new HashMap<Integer, Long>();

    public LcovReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    public void handleReport(String report) throws ReportParserException {
        int startOfCurrentLineOffset = 0;
        int currentLine = 0;
        while (startOfCurrentLineOffset >= 0) {
            startOfCurrentLineOffset = this.processNextLine(report, startOfCurrentLineOffset, currentLine);
            ++currentLine;
        }
    }

    private int processNextLine(String report, int startOfCurrentLineOffset, int currentLine) throws ReportParserException {
        int startOfNextLine;
        if (report.startsWith(SF, startOfCurrentLineOffset)) {
            return this.processFileName(report, startOfCurrentLineOffset);
        }
        if (report.startsWith(DA, startOfCurrentLineOffset)) {
            this.requireCurrentFile(currentLine);
            return this.processCoverageInfoLine(report, startOfCurrentLineOffset, currentLine);
        }
        if (report.startsWith(BRDA, startOfCurrentLineOffset)) {
            this.requireCurrentFile(currentLine);
            return this.processBranchCoverageInfoLine(report, startOfCurrentLineOffset, currentLine);
        }
        if (report.startsWith(END_OF_RECORD, startOfCurrentLineOffset)) {
            this.requireCurrentFile(currentLine);
            this.processEndOfRecord();
        }
        if ((startOfNextLine = report.indexOf(10, startOfCurrentLineOffset)) < 0) {
            return -1;
        }
        return startOfNextLine + 1;
    }

    private int processFileName(String report, int startOfCurrentLineOffset) {
        int fileStartOffset = startOfCurrentLineOffset + SF_LENGTH;
        if (report.startsWith("./", fileStartOffset)) {
            fileStartOffset += 2;
        }
        int endOfLine = report.indexOf(10, fileStartOffset);
        int fileEndOffset = LcovReportHandler.getOffsetForLastCharacterBeforeEndOfLine(report, endOfLine);
        this.currentFile = report.substring(fileStartOffset, fileEndOffset);
        this.lineToBranchesTaken.clear();
        this.lineToBranchesNotTaken.clear();
        return endOfLine;
    }

    private int processCoverageInfoLine(String report, int startOfCurrentLineOffset, int currentLine) throws ReportParserException {
        int numberStartOffset = startOfCurrentLineOffset + DA_LENGTH;
        int separatorOffset = report.indexOf(44, startOfCurrentLineOffset);
        int endOfLine = report.indexOf(10, separatorOffset);
        int secondNumberEndOffset = LcovReportHandler.getOffsetForLastCharacterBeforeEndOfLine(report, endOfLine);
        int nextCommaOffset = report.indexOf(44, separatorOffset + 1);
        if (nextCommaOffset >= 0 && nextCommaOffset < secondNumberEndOffset) {
            secondNumberEndOffset = nextCommaOffset;
        }
        int line = (int)LcovReportHandler.parseNumber(report.substring(numberStartOffset, separatorOffset), "line number", currentLine);
        long executionCount = LcovReportHandler.parseNumber(report.substring(separatorOffset + 1, secondNumberEndOffset), "execution count", currentLine);
        this.lineToExecutions.put(line, executionCount);
        return endOfLine + 1;
    }

    private int processBranchCoverageInfoLine(String report, int startOfCurrentLineOffset, int currentLine) throws ReportParserException {
        int numberStartOffset = startOfCurrentLineOffset + BRDA_LENGTH;
        int separatorOffset = report.indexOf(44, startOfCurrentLineOffset);
        int secondComma = report.indexOf(44, separatorOffset + 1);
        int thirdComma = report.indexOf(44, secondComma + 1);
        int endOfLine = report.indexOf(10, thirdComma + 1);
        int line = (int)LcovReportHandler.parseNumber(report.substring(numberStartOffset, separatorOffset), "line number", currentLine);
        long executionCount = LcovReportHandler.parseNumber(report.substring(thirdComma + 1, LcovReportHandler.getOffsetForLastCharacterBeforeEndOfLine(report, endOfLine)), "execution count", currentLine);
        if (executionCount > 0L) {
            this.lineToBranchesTaken.inc((Object)line);
        } else {
            this.lineToBranchesNotTaken.inc((Object)line);
        }
        return endOfLine + 1;
    }

    private void processEndOfRecord() {
        LineCoverageInfo lineCoverageInfo = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(this.currentFile);
        this.lineToExecutions.forEach((line, executionCount) -> lineCoverageInfo.addLineCoverage(line.intValue(), this.getLineCoverage((int)line, (long)executionCount)));
        this.lineToExecutions.clear();
    }

    private static int getOffsetForLastCharacterBeforeEndOfLine(String report, int newLineCharacterOffset) {
        int offsetForLastCharacterBeforeEndOfline = newLineCharacterOffset;
        if (report.charAt(offsetForLastCharacterBeforeEndOfline - 1) == '\r') {
            --offsetForLastCharacterBeforeEndOfline;
        }
        return offsetForLastCharacterBeforeEndOfline;
    }

    private void requireCurrentFile(int reportLineNumber) throws ReportParserException {
        if (this.currentFile == null) {
            throw new ReportParserException("Parse error. No file for coverage info in line " + reportLineNumber);
        }
    }

    private ELineCoverage getLineCoverage(int line, long executionCount) {
        if (executionCount > 0L) {
            if (this.lineToBranchesTaken.getValue((Object)line) > 0 && this.lineToBranchesNotTaken.getValue((Object)line) > 0) {
                return ELineCoverage.PARTIALLY_COVERED;
            }
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }

    private static long parseNumber(String s, String numberName, int lineNumber) throws ReportParserException {
        if ("-".equals(s)) {
            return 0L;
        }
        if ("NaN".equals(s)) {
            LOGGER.error("LCOV report contains {} with value 'NaN'. This indicates memory corruption in the tested application. As a conservative strategy the execution count will be set to 0. Any other execution counts may be corrupted as well and consequently the contained coverage may not represent the actual coverage.", (Object)numberName);
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            try {
                BigDecimal largeValue = new BigDecimal(s);
                LOGGER.error("LCOV report contains {} of value {} which is larger than a Java long. This indicates memory corruption in the tested application. As a conservative strategy the execution count will be set to 0. Any other execution counts may be corrupted as well and consequently the contained coverage may not represent the actual coverage.", (Object)numberName, (Object)largeValue);
                return 0L;
            }
            catch (NumberFormatException e1) {
                throw new ReportParserException("Parser error. Expected integer for " + numberName + " in line " + lineNumber + ". " + e.getMessage());
            }
        }
    }
}

