/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.CallStatementCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-call-system-function", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CallSystemFunctionCheck
extends CallStatementCheckBase {
    private static final String CHECK_NAME = "Suspicious usage of CALL system function";
    private static final EnumSet<ETokenType> OTHER_CALL_TOKEN_TYPES = EnumSet.of(ETokenType.BADI, new ETokenType[]{ETokenType.CUSTOMER_FUNCTION, ETokenType.DATABASE, ETokenType.DIALOG, ETokenType.FUNCTION, ETokenType.METHOD, ETokenType.SCREEN, ETokenType.SELECTION_SCREEN, ETokenType.SUBSCREEN, ETokenType.TRANSACTION, ETokenType.TRANSFORMATION});
    @CheckOption(name="Suspicious usage of CALL system function - System function names", description="Comma separated list of system function names. Depending on the blacklist/whitelist flag, this specifies the unwanted or allowed functions.")
    private Set<String> functionNames = new HashSet<String>(CollectionUtils.asHashSet((Object[])new String[]{"SYSTEM", "ThWpInfo"}));
    @CheckOption(name="Suspicious usage of CALL system function - Use as Whitelist", description="If enabled, function names specify allowed functions, all other usages of 'CALL cfunc' are detected.")
    private boolean isWhitelist = false;
    @CheckOption(name="Suspicious usage of CALL system function - Allowed commands in CALL 'SYSTEM'", description="Comma separated list (regular expressions) for operating system commands which are allowed in CALL 'SYSTEM'. If system function 'SYSTEM' is whitelisted, this option has no effect.")
    private Set<String> osCommandWhitelist = Collections.emptySet();

    @Override
    protected boolean isTargetedCallStatement(ETokenType typeOfsecondToken) {
        return !OTHER_CALL_TOKEN_TYPES.contains(typeOfsecondToken);
    }

    @Override
    protected void processCallStatement() throws CheckException {
        String calledFunction = CheckUtils.getUnquotedTextForCharacterLiteral((IToken)((IToken)this.getCallStatmentTokens().get(1)));
        if (calledFunction == null) {
            this.buildFinding("Usage of `CALL cfunc` (dynamic call)", this.buildLocation().forEntity(this.getCallStatement())).createAndStore();
            return;
        }
        if (this.functionNames.contains(calledFunction) == this.isWhitelist) {
            return;
        }
        if (calledFunction.equals("SYSTEM") && this.isWhitlistedOsCommand()) {
            return;
        }
        this.buildFinding("Usage of `CALL '" + calledFunction + "'`", this.buildLocation().forEntity(this.getCallStatement())).createAndStore();
    }

    private boolean isWhitlistedOsCommand() {
        if (CollectionUtils.isNullOrEmpty(this.osCommandWhitelist)) {
            return false;
        }
        String command = CallSystemFunctionCheck.findCommand(this.getCallStatmentTokens());
        if (command == null) {
            return false;
        }
        return this.osCommandWhitelist.stream().anyMatch(s -> command.matches((String)s));
    }

    private static String findCommand(UnmodifiableList<IToken> tokens) {
        for (int i = 0; i < tokens.size() - 3; ++i) {
            if (((IToken)tokens.get(i)).getType() != ETokenType.ID || !((IToken)tokens.get(i + 1)).getText().equals("'COMMAND'") || ((IToken)tokens.get(i + 2)).getType() != ETokenType.FIELD) continue;
            return CheckUtils.getUnquotedTextForCharacterLiteral((IToken)((IToken)tokens.get(i + 3)));
        }
        return null;
    }
}

