/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.OpenSqlWriteStatement;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-db-operation-in-macro", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class NoDbOperationInMacroCheck
extends CheckImplementationBase {
    private static final String GENERAL_MESSAGE = "A macro should not contain database operations";
    private static final String FINDING_MESSAGE_OBJECT_SERVICES = "A macro should not contain database operations but found string '%s' indicating a database operation using Object Services";
    private static final String FINDING_MESSAGE_NATIVE_SQL_STATEMENT = "A macro should not contain database operations but found Native SQL statement '%s'";
    private static final String FINDING_MESSAGE_NATIVE_SQL_CLASS = "A macro should not contain database operations but found Native SQL class '%s'";
    private static final String FINDING_MESSAGE_OPEN_SQL_STATEMENT = "A macro should not contain database operations but found Open SQL statement '%s'";
    private static final String REGEX_PERSISTENCE_SERVICE_1 = "(create|get|delete)_persistent";
    private static final String REGEX_PERSISTENCE_SERVICE_2 = "(create|get)_transient";
    private static final String REGEX_TRANSACTION_SERVICE_1 = "get_transaction_manager";
    private static final String REGEX_TRANSACTION_SERVICE_2 = "(create|get_current|get_top)_transaction";
    private static final String REGEX_QUERY_SERVICE_1 = "get_query_manager";
    private static final String REGEX_QUERY_SERVICE_2 = "create_query";
    private static final String REGEX_QUERY_SERVICE_3 = "get_expr_factory";
    private static final String REGEX_QUERY_SERVICE_4 = "set_(filter|parameters|ordering)_expr";
    private static final String REGEX_QUERY_SERVICE_5 = "create_(operator|like|isnull|ref|and|not|or|parameters|ordering)_expr";
    private static final Pattern PATTERN_OBJECT_SERVICE_USE = Pattern.compile("(create|get|delete)_persistent|(create|get)_transient|get_query_manager|create_query|get_expr_factory|set_(filter|parameters|ordering)_expr|create_(operator|like|isnull|ref|and|not|or|parameters|ordering)_expr|get_transaction_manager|(create|get_current|get_top)_transaction", 2);
    private static final Pattern PATTERN_NATIVE_SQL_CLASSES = Pattern.compile("^C[LX]_SQL_.*", 2);

    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            if (!metaEntity.getSubtype().equals("macro")) continue;
            this.processEntity(metaEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        CCSMAssert.isFalse((boolean)entity.hasChildren(), (String)"Assumption 'Macro entity has no children' is violated.");
        UnmodifiableList tokens = entity.ownStartTokens();
        List tokenLists = TokenStreamUtils.split((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.DOT});
        this.checkForOpenSqlOperations(tokenLists, entity);
        this.checkForNativeSQLOperation(tokenLists);
        this.checkForObjectServiceOperation(tokenLists);
    }

    private void checkForObjectServiceOperation(List<List<IToken>> macroStatements) throws CheckException {
        for (List<IToken> currentTokenList : macroStatements) {
            this.createFindingsForIdentifiersContainingPattern(currentTokenList, PATTERN_OBJECT_SERVICE_USE, FINDING_MESSAGE_OBJECT_SERVICES);
        }
    }

    private void checkForNativeSQLOperation(List<List<IToken>> macroStatements) throws CheckException {
        for (List<IToken> currentTokenList : macroStatements) {
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_NATIVE_SQL_STATEMENT, ETokenType.EXEC, ETokenType.SQL);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_NATIVE_SQL_STATEMENT, ETokenType.ENDEXEC);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_NATIVE_SQL_STATEMENT, ETokenType.EXIT, ETokenType.FROM, ETokenType.SQL);
            this.createFindingsForIdentifiersContainingPattern(currentTokenList, PATTERN_NATIVE_SQL_CLASSES, FINDING_MESSAGE_NATIVE_SQL_CLASS);
        }
    }

    private void findTokenTypeSequenceInTokenListAndCreateFinding(List<IToken> tokens, String formatString, ETokenType ... tokenTypes) throws CheckException {
        int position = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])tokenTypes);
        if (position != -1) {
            String tokenTypesAsString = Stream.of(tokenTypes).map(Enum::toString).collect(Collectors.joining(" "));
            String findingMessage = String.format(formatString, tokenTypesAsString);
            this.buildFinding(findingMessage, this.buildLocation().forToken(tokens.get(position))).createAndStore();
        }
    }

    private void checkForOpenSqlOperations(List<List<IToken>> macroStatements, ShallowEntity macroEntity) throws CheckException {
        for (List<IToken> currentTokenList : macroStatements) {
            OpenSqlWriteStatement statement;
            if (currentTokenList == null || currentTokenList.isEmpty()) continue;
            if (TokenStreamUtils.containsAny(currentTokenList, (int)0, (int)1, (ETokenType[])new ETokenType[]{ETokenType.INSERT, ETokenType.UPDATE, ETokenType.MODIFY, ETokenType.DELETE}) && (statement = OpenSqlWriteStatement.create((ShallowEntity)macroEntity, currentTokenList, (ITypeResolution)this.context.getTypeResolution(ECodeViewOption.FILTERED))) != null) {
                this.buildFinding(String.format(FINDING_MESSAGE_OPEN_SQL_STATEMENT, statement.getStatementStartToken().getText()), this.buildLocation().forToken(currentTokenList.get(0))).createAndStore();
            }
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.SELECT);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.END, ETokenType.SELECT);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.OPEN, ETokenType.CURSOR);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.FETCH, ETokenType.NEXT, ETokenType.CURSOR);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.CLOSE, ETokenType.CURSOR);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.COMMIT, ETokenType.WORK);
            this.findTokenTypeSequenceInTokenListAndCreateFinding(currentTokenList, FINDING_MESSAGE_OPEN_SQL_STATEMENT, ETokenType.ROLLBACK, ETokenType.WORK);
        }
    }

    private void createFindingsForIdentifiersContainingPattern(List<IToken> tokens, Pattern pattern, String messageTemplate) throws CheckException {
        for (IToken currentToken : tokens) {
            if (!currentToken.getType().equals((Object)ETokenType.IDENTIFIER) || !pattern.matcher(currentToken.getText()).find()) continue;
            this.buildFinding(String.format(messageTemplate, currentToken.getText()), this.buildLocation().forToken(currentToken)).createAndStore();
        }
    }
}

