/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-pragma", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PragmaCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Pragmas should not be used";
    @CheckOption(name="Pragmas should not be used - Pragma selection", description="Regular expression for selecting pragmas, for example 'SHADOW.*'. Matches only against the pragma text, without '##'. If it is specified, the check option 'Use pragma selection as whitelist' specifies whether it is treated as a white list or a black list. If it is not specified, all pragmas are reported as finding.")
    private String selectedPragmasRegex = "";
    @CheckOption(name="Pragmas should not be used - Use pragma selection as whitelist", description="If enabled, 'pragma selection' is treated as white list (all pragmas not matching 'pragma selection' are reported as finding). If not enabled, 'pragma selection' is treated as black list (all pragmas matching 'pragma selection' are reported as finding).")
    private boolean isWhitelist = false;
    private Pattern selectedPragmasPattern;

    public void initialize() throws CheckException {
        this.selectedPragmasPattern = CheckUtils.compilePatternFromCheckOptionRegex((String)this.selectedPragmasRegex, (String)CHECK_NAME, (String)"pragma selection");
    }

    public void execute() throws CheckException {
        for (int i = 0; i < this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED).size(); ++i) {
            IToken token = (IToken)this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED).get(i);
            if (token.getType() != ETokenType.PRAGMA_DIRECTIVE) continue;
            this.processPragma(token.getText(), token.getLineNumber() + 1);
        }
    }

    private void processPragma(String pragmaText, int line) throws CheckException {
        if (!this.isAllowedPragma(pragmaText)) {
            this.buildFinding("Pragma ``" + pragmaText + "`` should not be used", this.buildLocation().forLine(line)).createAndStore();
        }
    }

    private boolean isAllowedPragma(String pragmaText) {
        String pragmaName = StringUtils.stripPrefix((String)pragmaText, (String)"##");
        if (this.selectedPragmasPattern == null) {
            return false;
        }
        if (this.selectedPragmasPattern.matcher(pragmaName).matches()) {
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }
}

