/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class SystemVariablesCheckBase
extends CheckImplementationBase {
    public static final Pattern ABAP_CONTEXT_INFO_CLASS_TEXT_PATTERN = Pattern.compile("(?i)cl_abap_context_info");
    public static final Pattern ABAP_XCO_LIBRARY_CLASS_TEXT_PATTERN = Pattern.compile("(?i)xco_cp");
    private static final EnumSet<ETokenType> CONTROL_STATEMENT_TOKENS = EnumSet.of(ETokenType.IF, new ETokenType[]{ETokenType.ELSEIF, ETokenType.CASE, ETokenType.WHEN, ETokenType.WHILE, ETokenType.SWITCH});
    private static final EnumSet<ETokenType> TYPE_DECLARATION_TOKENS = EnumSet.of(ETokenType.TYPE, ETokenType.LIKE);
    private static final EnumSet<ETokenType> CONDITION_END_TOKENS = EnumSet.of(ETokenType.DOT, ETokenType.THEN);
    private static final List<ETokenType> STATIC_METHOD_CALL_TOKENS = List.of(ETokenType.IDENTIFIER, ETokenType.EQGT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.RPAREN);
    private static final Pattern XCO_SY_LIBRARY_TEXT_PATTERN = Pattern.compile("(?i)sy");
    private static final List<ETokenType> XCO_METHOD_CALL_TOKENS = List.of(ETokenType.IDENTIFIER, ETokenType.EQGT, ETokenType.IDENTIFIER, ETokenType.ARROW);
    private static final Pattern ABAP_XCO_SY_USER_METHOD_TEXT_PATTERN = Pattern.compile("(?i)user");
    private Pattern systemVariableTokenTextPattern = Pattern.compile("(?i)sy-[a-z]{2,5}");
    private Pattern abapContextInfoMethodTextPattern = Pattern.compile("(?i)[a-z_]{14,30}");

    public void execute() throws CheckException {
        this.buildTokenTextPattern();
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        for (int i = 0; i < tokens.size(); ++i) {
            if (this.isSystemVariable((List<IToken>)tokens, i)) {
                this.performSystemVariableCheck((List<IToken>)tokens, i);
            }
            if (this.hasAbapContextInfoMethodCall((List<IToken>)tokens, i)) {
                this.performAbapContextInfoMethodCheck((List<IToken>)tokens, i);
            }
            if (!SystemVariablesCheckBase.hasXcoSyLibraryMethodCall((List<IToken>)tokens, i)) continue;
            this.performAbapXcoLibraryMethodCheck((List<IToken>)tokens, i);
        }
    }

    private void buildTokenTextPattern() {
        this.buildSystemVariableTextPattern();
        this.buildAbapContextInfoMethodPattern();
    }

    private void buildSystemVariableTextPattern() {
        String patternForFieldsToCheck = this.getSystemFieldsToCheck().stream().map(systemVariable -> systemVariable.replaceFirst("(?i)sy-", "")).collect(Collectors.joining("|"));
        if (!patternForFieldsToCheck.isEmpty()) {
            this.systemVariableTokenTextPattern = Pattern.compile("(?i)sy-(" + patternForFieldsToCheck + ")");
        }
    }

    private void buildAbapContextInfoMethodPattern() {
        String patternForMethodsToCheck = this.getAbapContextInfoMethodsToCheck().stream().collect(Collectors.joining("|"));
        if (!patternForMethodsToCheck.isEmpty()) {
            this.abapContextInfoMethodTextPattern = Pattern.compile("(?i)(" + patternForMethodsToCheck + ")");
        }
    }

    private boolean isSystemVariable(List<IToken> tokens, int index) {
        if (!this.hasSystemVariableName(tokens.get(index))) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        return !TYPE_DECLARATION_TOKENS.contains(tokens.get(index - 1).getType());
    }

    private boolean hasSystemVariableName(IToken token) {
        if (!token.getType().isIdentifier()) {
            return false;
        }
        return this.systemVariableTokenTextPattern.matcher(token.getText()).matches();
    }

    private boolean hasAbapContextInfoMethodCall(List<IToken> tokens, int startTokenIndex) {
        if (!TokenStreamUtils.hasTokenTypeSequence(tokens, (int)startTokenIndex, STATIC_METHOD_CALL_TOKENS)) {
            return false;
        }
        String classTokenText = tokens.get(startTokenIndex).getText();
        if (!ABAP_CONTEXT_INFO_CLASS_TEXT_PATTERN.matcher(classTokenText).matches()) {
            return false;
        }
        String methodTokenText = tokens.get(startTokenIndex + 2).getText();
        return this.abapContextInfoMethodTextPattern.matcher(methodTokenText).matches();
    }

    private static boolean hasXcoSyLibraryMethodCall(List<IToken> tokens, int startTokenIndex) {
        if (!TokenStreamUtils.hasTokenTypeSequence(tokens, (int)startTokenIndex, XCO_METHOD_CALL_TOKENS)) {
            return false;
        }
        String classTokenText = tokens.get(startTokenIndex).getText();
        String instanceTokenText = tokens.get(startTokenIndex + 2).getText();
        if (!ABAP_XCO_LIBRARY_CLASS_TEXT_PATTERN.matcher(classTokenText).matches() && !XCO_SY_LIBRARY_TEXT_PATTERN.matcher(instanceTokenText).matches()) {
            return false;
        }
        String methodTokenText = tokens.get(startTokenIndex + 4).getText();
        return ABAP_XCO_SY_USER_METHOD_TEXT_PATTERN.matcher(methodTokenText).matches();
    }

    protected static boolean isInControlStatement(List<IToken> tokens, int index) {
        boolean result = false;
        for (int tokenIndex = index - 1; tokenIndex >= 0; --tokenIndex) {
            ETokenType tokenType = tokens.get(tokenIndex).getType();
            if (tokenType == ETokenType.VALUE) {
                return false;
            }
            if (CONDITION_END_TOKENS.contains(tokenType)) {
                return result;
            }
            if (!CONTROL_STATEMENT_TOKENS.contains(tokenType)) continue;
            result = true;
        }
        return result;
    }

    protected abstract Set<String> getSystemFieldsToCheck();

    protected abstract Set<String> getAbapContextInfoMethodsToCheck();

    protected abstract void performSystemVariableCheck(List<IToken> var1, int var2) throws CheckException;

    protected abstract void performAbapContextInfoMethodCheck(List<IToken> var1, int var2) throws CheckException;

    protected abstract void performAbapXcoLibraryMethodCheck(List<IToken> var1, int var2) throws CheckException;
}

