/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap_cds;

import eu.cqse.check.abap_cds.AbapCdsCheckUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Check(id="cqse-vdm-view-type-exists-check", languages={ELanguage.ABAP, ELanguage.ABAP_CDS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class VDMViewTypeExistsCheck
extends CheckImplementationBase {
    private static final String VDM_VIEW_TYPE_ANNOTATION_ENTITY_NAME = "vdm.viewtype";
    @CheckOption(name="Alternative VDM view type annotation", description="By default, this check searches for \"vdm.viewtype\" annotations in CDS view definitions. \nThis option can configure a second annotation name that the check should search for. \nFor example, `@My.view.type`.")
    private String alternativeAnnotation = "";

    public void initialize() throws CheckException {
        if (this.alternativeAnnotation.startsWith("@")) {
            this.alternativeAnnotation = this.alternativeAnnotation.substring(1);
        }
        this.alternativeAnnotation = this.alternativeAnnotation.toLowerCase();
    }

    public void execute() throws CheckException {
        if (!AbapCdsCheckUtils.isAbapCdsViewDefinition((ITokenElementContext)this.context)) {
            return;
        }
        List entities = ShallowEntityTraversalUtils.selectEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), entity -> EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.META).contains(entity.getType()) && Set.of("View Definition", "View Entity Definition", "Annotation with value").contains(entity.getSubtype()));
        ShallowEntity typeViewAnnotation = null;
        for (ShallowEntity entity2 : entities) {
            if (entity2.getType() == EShallowEntityType.METHOD) {
                if (typeViewAnnotation == null) {
                    this.buildFinding("Missing VDM view type annotation for the ABAP CDS view definition", this.buildLocation().forEntity(entity2)).createAndStore();
                }
                typeViewAnnotation = null;
                continue;
            }
            if (!Objects.equals(entity2.getName(), VDM_VIEW_TYPE_ANNOTATION_ENTITY_NAME) && !this.isVDMViewTypeAlternativeAnnotation(entity2.getName())) continue;
            typeViewAnnotation = entity2;
        }
    }

    private boolean isVDMViewTypeAlternativeAnnotation(String entityName) {
        if (this.alternativeAnnotation.isEmpty()) {
            return false;
        }
        return this.alternativeAnnotation.equals(entityName);
    }
}

