/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;

public abstract class CLikeFieldUsageCheckBase
extends CheckImplementationBase {
    protected CLikeLanguageFeatureParserBase languageFeatureParser;
    private static final ECodeViewOption CODE_VIEW_OPTION = ECodeViewOption.UNFILTERED_PREPROCESSED;

    protected CLikeFieldUsageCheckBase(CLikeLanguageFeatureParserBase languageFeatureParser) {
        CCSMAssert.isNotNull((Object)languageFeatureParser);
        this.languageFeatureParser = languageFeatureParser;
    }

    public void execute() throws CheckException {
        ListMap<ShallowEntity, ShallowEntity> declarationsByTypes = this.getDeclarationsByTypes();
        for (ShallowEntity typeDeclaration : declarationsByTypes.getKeys()) {
            if (this.isParentTypeFiltered(typeDeclaration)) continue;
            String xPath = this.getProcessedEntitiesXPath();
            List entitiesToAnalyze = CLikeFieldUsageCheckBase.select((ShallowEntity)typeDeclaration, (String)xPath);
            ShallowEntity parent = typeDeclaration.getParent();
            if (parent != null && parent.getType() == EShallowEntityType.TYPE) {
                List additionalAnalysisCandidates = CLikeFieldUsageCheckBase.select((ShallowEntity)parent, (String)xPath);
                entitiesToAnalyze.addAll(CLikeFieldUsageCheckBase.getStatementsWithObjectAccess(additionalAnalysisCandidates));
            }
            for (Pair<IToken, ShallowEntity> unusedVariableToken : this.determineFieldsWithFinding(entitiesToAnalyze, this.getFieldTokensWithDeclaringEntities(declarationsByTypes, typeDeclaration))) {
                IToken token = (IToken)unusedVariableToken.getFirst();
                this.buildFinding(this.getFindingMessage(token.getText()), this.buildLocation().betweenOffsets(token.getOffset(), token.getEndOffset(), CLikeFieldUsageCheckBase.CODE_VIEW_OPTION.textView)).createAndStore();
            }
        }
    }

    protected boolean isParentTypeFiltered(ShallowEntity type) {
        return false;
    }

    private ListMap<ShallowEntity, ShallowEntity> getDeclarationsByTypes() throws CheckException {
        ListMap declarationsByType = new ListMap();
        List fieldDeclarations = CLikeFieldUsageCheckBase.select((ShallowEntity)this.context.getRootEntity(CODE_VIEW_OPTION), (String)this.getFieldSelectionXPath());
        fieldDeclarations.forEach(declaration -> {
            if (this.isFiltered((ShallowEntity)declaration)) {
                return;
            }
            declarationsByType.add((Object)declaration.getParent(), declaration);
        });
        return declarationsByType;
    }

    private Set<Pair<IToken, ShallowEntity>> getFieldTokensWithDeclaringEntities(ListMap<ShallowEntity, ShallowEntity> declarationsByTypes, ShallowEntity type) {
        return ((List)declarationsByTypes.getCollection((Object)type)).stream().flatMap(declaration -> this.languageFeatureParser.getVariableNamesFromTokens((List)declaration.ownStartTokens()).stream().map(fieldToken -> new Pair(fieldToken, declaration))).collect(Collectors.toSet());
    }

    private Set<Pair<IToken, ShallowEntity>> determineFieldsWithFinding(List<ShallowEntity> entitesToAnalyze, Set<Pair<IToken, ShallowEntity>> unanalyzedFieldTokenToParentEntity) throws CheckException {
        Set<Object> failedAnalyzedFieldTokenToParentEntity = new HashSet<Pair<IToken, ShallowEntity>>(unanalyzedFieldTokenToParentEntity);
        ITypeResolution typeResolution = this.context.getTypeResolution(CODE_VIEW_OPTION);
        for (ShallowEntity entityToAnalyze : entitesToAnalyze) {
            ScopedTypeLookup typeLookup;
            Set<Pair<IToken, ShallowEntity>> fieldsWithAnalyzeSuccess = this.determineFieldsWithAnalyzeSuccess(failedAnalyzedFieldTokenToParentEntity, entityToAnalyze, typeLookup = typeResolution.getTypeLookup(entityToAnalyze));
            if (!fieldsWithAnalyzeSuccess.isEmpty()) {
                failedAnalyzedFieldTokenToParentEntity = CollectionUtils.subtract(failedAnalyzedFieldTokenToParentEntity, fieldsWithAnalyzeSuccess);
            }
            if (!failedAnalyzedFieldTokenToParentEntity.isEmpty()) continue;
            break;
        }
        return this.filterFieldsWithFinding(unanalyzedFieldTokenToParentEntity, failedAnalyzedFieldTokenToParentEntity);
    }

    protected Set<Pair<IToken, ShallowEntity>> filterFieldsWithFinding(Set<Pair<IToken, ShallowEntity>> unanalyzedFieldTokenToParentEntity, Set<Pair<IToken, ShallowEntity>> failedAnalyzedFieldTokenToParentEntity) {
        if (this.createFindingOnFound()) {
            return CollectionUtils.subtract(unanalyzedFieldTokenToParentEntity, failedAnalyzedFieldTokenToParentEntity);
        }
        return failedAnalyzedFieldTokenToParentEntity;
    }

    private Set<Pair<IToken, ShallowEntity>> determineFieldsWithAnalyzeSuccess(Set<Pair<IToken, ShallowEntity>> fieldsToCheck, ShallowEntity currentEntity, ScopedTypeLookup typeLookup) {
        HashSet<Pair<IToken, ShallowEntity>> fieldsWithAnalyzeSuccess = new HashSet<Pair<IToken, ShallowEntity>>();
        List ownTokens = currentEntity.ownTokens();
        EShallowEntityType currentEntityType = currentEntity.getType();
        for (Pair<IToken, ShallowEntity> fieldWithNameToken : fieldsToCheck) {
            IToken fieldToken = (IToken)fieldWithNameToken.getFirst();
            ShallowEntity field = (ShallowEntity)fieldWithNameToken.getSecond();
            if (field == currentEntity) continue;
            String fieldName = fieldToken.getText();
            boolean isShadowed = typeLookup.isShadowingVariable(fieldName, field);
            for (List ownToken : ownTokens) {
                boolean foundInTokens = this.analyzeTokens(ownToken, fieldName, currentEntityType, isShadowed);
                if (!foundInTokens) continue;
                fieldsWithAnalyzeSuccess.add(fieldWithNameToken);
            }
        }
        return fieldsWithAnalyzeSuccess;
    }

    protected boolean isFiltered(ShallowEntity field) {
        return false;
    }

    protected abstract boolean analyzeTokens(List<IToken> var1, String var2, EShallowEntityType var3, boolean var4);

    protected abstract String getFieldSelectionXPath();

    protected abstract String getProcessedEntitiesXPath();

    protected abstract String getFindingMessage(String var1);

    private boolean createFindingOnFound() {
        return false;
    }

    private static List<ShallowEntity> getStatementsWithObjectAccess(List<ShallowEntity> entities) {
        return entities.stream().filter(entity -> {
            boolean isStatement = entity.getType() == EShallowEntityType.STATEMENT;
            boolean accessesObject = entity.ownStartTokens().size() > 1 && ((IToken)entity.ownStartTokens().get(1)).getType() == ETokenType.DOT;
            return isStatement && accessesObject;
        }).collect(Collectors.toList());
    }
}

