/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;

public abstract class UnwantedExpressionBase
extends CheckImplementationBase {
    private Pattern unwantedRegex;

    protected abstract Pattern getUnwantedRegex();

    public void initialize() throws CheckException {
        super.initialize();
        this.unwantedRegex = this.getUnwantedRegex();
    }

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), this.getTargetTypes());
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    protected @NonNull EnumSet<EShallowEntityType> getTargetTypes() {
        return EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT, EShallowEntityType.META, EShallowEntityType.TYPE);
    }

    private void processEntity(ShallowEntity entity) {
        MatchResult matchResult;
        Matcher endMatcher;
        Matcher startMatcher = this.unwantedRegex.matcher(TokenStreamTextUtils.concatTokenTexts((List)entity.ownStartTokens()));
        if (startMatcher.find()) {
            MatchResult matchResult2 = startMatcher.toMatchResult();
            if (!this.shouldIgnore(matchResult2)) {
                this.buildFinding(this.getFindingText(entity, matchResult2), this.buildLocation().forLine(entity.getStartLine())).createAndStore();
            }
        } else if (entity.hasChildren() && (endMatcher = this.unwantedRegex.matcher(TokenStreamTextUtils.concatTokenTexts((List)entity.ownEndTokens()))).find() && !this.shouldIgnore(matchResult = endMatcher.toMatchResult())) {
            this.buildFinding(this.getFindingText(entity, matchResult), this.buildLocation().forLine(entity.getEndLine())).createAndStore();
        }
    }

    protected boolean shouldIgnore(MatchResult matchResult) {
        return false;
    }

    protected abstract String getFindingText(ShallowEntity var1, MatchResult var2);
}

