/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

@Check(id="cqse-explicit-constructor", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ExplicitConstructorCheck
extends CheckImplementationBase {
    private static final Pattern LIST_INIT_PATTERN = Pattern.compile(".*?(std::)?initializer_list.*?");

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            for (ShallowEntity child : type.getChildren()) {
                if (!child.getType().equals((Object)EShallowEntityType.METHOD) || !"constructor declaration".equals(child.getSubtype()) || ExplicitConstructorCheck.constructorShouldBeIgnored(child)) continue;
                this.checkConstructor(child);
            }
        }
    }

    private static boolean constructorShouldBeIgnored(ShallowEntity constructor) {
        return LanguageFeatureParser.CPP.isCpp11DeletedFunctionOrConstructor(constructor);
    }

    private void checkConstructor(ShallowEntity constructor) {
        boolean isAllowedType;
        List parameterList = LanguageFeatureParser.CPP.getSplitParameterTokens(constructor);
        String className = constructor.getParent().getName();
        boolean oneParameter = parameterList.size() == 1;
        boolean isExplicit = TokenStreamUtils.contains((List)constructor.ownStartTokens(), (ETokenType)ETokenType.EXPLICIT);
        boolean isMove = ExplicitConstructorCheck.isMoveConstructor(parameterList, className);
        boolean isCopy = ExplicitConstructorCheck.isCopyConstructor(parameterList, className);
        boolean isListInit = ExplicitConstructorCheck.isListInitializer(parameterList);
        boolean bl = isAllowedType = isListInit || isMove || isCopy;
        if (oneParameter && !isExplicit && !isAllowedType) {
            this.buildFinding("Constructor `" + className + "` should be declared explicit", this.buildLocation().forEntity(constructor)).createAndStore();
        }
        if (isExplicit && isAllowedType) {
            this.buildFinding("Constructor `" + className + "` shouldn't be declared explicit", this.buildLocation().forEntity(constructor)).createAndStore();
        }
    }

    private static boolean isListInitializer(List<List<IToken>> parameterList) {
        if (parameterList.size() == 1) {
            String tokensString = TokenStreamTextUtils.concatTokenTexts(parameterList.get(0));
            return LIST_INIT_PATTERN.matcher(tokensString).matches();
        }
        return false;
    }

    private static boolean hasDefaultValue(List<IToken> parameterToken) {
        return TokenStreamUtils.contains(parameterToken, (ETokenType)ETokenType.EQ);
    }

    private static boolean isMoveConstructor(List<List<IToken>> parameterList, String className) {
        return ExplicitConstructorCheck.isMoveOrCopyConstructor(parameterList, className, ETokenType.ANDAND);
    }

    private static boolean isCopyConstructor(List<List<IToken>> parameterList, String className) {
        return ExplicitConstructorCheck.isMoveOrCopyConstructor(parameterList, className, ETokenType.AND);
    }

    private static boolean isMoveOrCopyConstructor(List<List<IToken>> parameterList, String className, ETokenType separator) {
        ListIterator<List<IToken>> iterator = parameterList.listIterator();
        boolean isMoveOrCopy = false;
        if (iterator.hasNext()) {
            List<IToken> firstParameter = iterator.next();
            int sequenceIndex = TokenStreamUtils.firstTokenOfTypeSequence(firstParameter, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, separator});
            boolean sequenceFound = sequenceIndex != -1;
            boolean bl = isMoveOrCopy = sequenceFound && firstParameter.get(sequenceIndex).getText().equals(className);
            if (isMoveOrCopy) {
                while (iterator.hasNext()) {
                    isMoveOrCopy = ExplicitConstructorCheck.hasDefaultValue(iterator.next());
                }
            }
        }
        return isMoveOrCopy;
    }
}

