/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.base.UnwantedMethodCallsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;

@Check(id="cqse-forbidden-double-precision-functions", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ForbiddenDoublePrecisionFunctionsCheck
extends UnwantedMethodCallsCheckBase {
    private static final Set<String> FORBIDDEN_FUNCTIONS = Set.of("acos", "acosh", "asin", "asinh", "atan", "atan2", "atanh", "cbrt", "ceil", "copysign", "cos", "cosh", "exp", "exp2", "expm1", "erf", "erfc", "fabs", "fdim", "floor", "fma", "fmax", "fmin", "fmod", "frexp", "hypot", "ilogb", "ldexp", "lgamma", "llrint", "llround", "log", "log10", "log1p", "log2", "logb", "lrint", "lround", "modf", "nan", "nearbyint", "nextafter", "nexttoward", "pow", "remainder", "remquo", "rint", "round", "scalbln", "scalbn", "sin", "sinh", "sqrt", "tan", "tanh", "tgamma", "trunc");
    private static final Set<String> FUNCTIONS_REQUIRING_ARGUMENT_ANALYSIS = Set.of("log");

    public void execute() throws CheckException {
        this.processTokens((List)this.context.getTokens(ECodeViewOption.FILTERED));
    }

    protected Set<String> getUnwantedMethods() {
        return FORBIDDEN_FUNCTIONS;
    }

    protected boolean shouldIgnoreMethod(List<IToken> tokens, int callIndex, String methodName) {
        if (!FUNCTIONS_REQUIRING_ARGUMENT_ANALYSIS.contains(methodName)) {
            return false;
        }
        return ForbiddenDoublePrecisionFunctionsCheck.hasIgnorableArgumentPattern(tokens, callIndex);
    }

    private static boolean hasIgnorableArgumentPattern(List<IToken> tokens, int callIndex) {
        List containedTokens = TokenStreamUtils.tokensBetweenWithNesting(tokens, (int)callIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (containedTokens.isEmpty()) {
            return true;
        }
        List parameters = TokenStreamUtils.splitWithNesting((List)containedTokens, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        return ForbiddenDoublePrecisionFunctionsCheck.hasMultipleParameters(parameters) || ForbiddenDoublePrecisionFunctionsCheck.hasStringParameter(parameters) || ForbiddenDoublePrecisionFunctionsCheck.isDeclaration(parameters);
    }

    private static boolean hasMultipleParameters(List<List<IToken>> parameters) {
        return parameters.size() > 1;
    }

    private static boolean hasStringParameter(List<List<IToken>> parameters) {
        return parameters.size() == 1 && parameters.getFirst().getFirst().getType() == ETokenType.STRING_LITERAL;
    }

    private static boolean isDeclaration(List<List<IToken>> parameters) {
        Pair typeInfo = LanguageFeatureParser.CPP.getModifiersAndTypeFromTokens(parameters.getFirst());
        String typeName = (String)typeInfo.getSecond();
        return typeName != null;
    }
}

