/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-no-declaration-in-namespace", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoDeclarationInNamespaceCheck
extends CheckImplementationBase {
    @CheckOption(name="Prohibited namespaces", description="Namespaces which should not be used in any sort of declaration.")
    private Set<String> prohibitedNamespaces = CollectionUtils.asHashSet((Object[])new String[]{"std"});
    private Pattern prohibitedNamespacesPattern;
    @CheckOption(name="Allowed class template specializations", description="Class template specializations that are allowed to be declared in namespaces given by the `Prohibited namespaces` option.")
    private Set<String> allowedSpecializations = CollectionUtils.asHashSet((Object[])new String[]{"std::hash", "std::complex", "std::numeric_limits", "std::common_type", "std::basic_common_reference", "std::atomic", "std::shared_ptr", "std::weak_ptr", "std::istreambuf_iterator"});
    private Map<String, Set<String>> allowedSpecializationsByNamespace = new HashMap<String, Set<String>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public void initialize() throws CheckException {
        this.allowedSpecializationsByNamespace = new HashMap<String, Set<String>>();
        HashSet<String> skippedSpecializations = new HashSet<String>();
        for (String allowedSpecialization : this.allowedSpecializations) {
            int indexOfLastDoubleColon = allowedSpecialization.lastIndexOf("::");
            if (indexOfLastDoubleColon == -1) {
                skippedSpecializations.add(allowedSpecialization);
                continue;
            }
            String namespace = allowedSpecialization.substring(0, indexOfLastDoubleColon);
            String classTemplateSpecialization = allowedSpecialization.substring(indexOfLastDoubleColon + 2);
            Set allowedSpecializations = this.allowedSpecializationsByNamespace.computeIfAbsent(namespace, value -> new HashSet());
            allowedSpecializations.add(classTemplateSpecialization);
            this.allowedSpecializationsByNamespace.put(namespace, allowedSpecializations);
        }
        this.prohibitedNamespacesPattern = Pattern.compile("(" + String.join((CharSequence)"|", this.prohibitedNamespaces) + ")");
        if (!skippedSpecializations.isEmpty()) {
            LOGGER.warn("Skipped the following template specializations: " + ((Object)skippedSpecializations).toString());
        }
        super.initialize();
    }

    public void execute() throws CheckException {
        List modules = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.MODULE);
        for (ShallowEntity module : modules) {
            if (!"namespace".equals(module.getSubtype()) || module.getName() == null || !this.prohibitedNamespacesPattern.matcher(module.getName()).matches()) continue;
            this.processEntity(module);
        }
    }

    private void processEntity(ShallowEntity namespace) {
        if (this.isAllowedTemplateSpecialization(namespace)) {
            return;
        }
        this.buildFinding("Do not declare anything in `" + namespace.getName() + "`", this.buildLocation().forEntity(namespace)).createAndStore();
    }

    private boolean isAllowedTemplateSpecialization(ShallowEntity namespaceEntity) {
        ArrayList children = new ArrayList(namespaceEntity.getChildren());
        if (children.size() % 2 != 0) {
            return false;
        }
        Set<String> allowedSpecializations = this.allowedSpecializationsByNamespace.getOrDefault(namespaceEntity.getName(), (Set<String>)CollectionUtils.emptySet());
        for (int i = 0; i < children.size(); i += 2) {
            ShallowEntity currentChild = (ShallowEntity)children.get(i);
            ShallowEntity nextChild = (ShallowEntity)children.get(i + 1);
            if (NoDeclarationInNamespaceCheck.hasTypeAndSubType(currentChild, EShallowEntityType.META, "template") && nextChild.getType() == EShallowEntityType.TYPE && allowedSpecializations.contains(nextChild.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasTypeAndSubType(ShallowEntity entity, EShallowEntityType type, String subtype) {
        return entity.getType() == type && entity.getSubtype().equals(subtype);
    }
}

