/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.clang;

import eu.cqse.check.cpp.clang.base.ClangCursorVisitorCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.clang.BinaryOperatorExpression;
import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.check.util.clang.misra.EEssentialTypeCategory;
import eu.cqse.check.util.clang.visitors.FindingCollectingClangCursorVisitorBase;
import eu.cqse.clang.CXChildVisitResult;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-operands-of-binary-operator-must-have-same-essential-type-category", languages={ELanguage.C}, parameters={ECheckParameter.CLANG})
public class OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheck
extends ClangCursorVisitorCheckBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> EXCLUDED_BINARY_OPERATORS = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"=", "<<", ">>", "&&", "||"});

    @Override
    protected OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor createVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
        return new OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor(translationUnit, uniformPath, fileText);
    }

    private static class OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor
    extends FindingCollectingClangCursorVisitorBase {
        private OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
            super(translationUnit, uniformPath, fileText);
        }

        public CXChildVisitResult visit(CXCursor cursor, CXCursor parent) {
            if (!ClangUtils.isBinaryOperatorOrCompoundAssignment((CXCursor)cursor)) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            Optional binaryOperatorExpression = BinaryOperatorExpression.createFromCursor((CXCursor)cursor, (String)this.fileText, (SWIGTYPE_p_CXTranslationUnitImpl)this.translationUnit);
            if (binaryOperatorExpression.isEmpty()) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            return this.visitBinaryOperatorExpression((BinaryOperatorExpression)binaryOperatorExpression.get());
        }

        private CXChildVisitResult visitBinaryOperatorExpression(BinaryOperatorExpression binaryOperatorExpression) {
            EEssentialTypeCategory rightHandOperandCategory;
            if (EXCLUDED_BINARY_OPERATORS.contains(binaryOperatorExpression.operator)) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            EEssentialTypeCategory leftHandOperandCategory = binaryOperatorExpression.leftHandOperandEssentialType.getCategory();
            if (!OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.isMatchingEssentialTypeCategory(binaryOperatorExpression.operator, leftHandOperandCategory, rightHandOperandCategory = binaryOperatorExpression.rightHandOperandEssentialType.getCategory())) {
                this.createFinding(binaryOperatorExpression.binaryExpressionCursor, leftHandOperandCategory, rightHandOperandCategory);
                return CXChildVisitResult.CXChildVisit_Continue;
            }
            return CXChildVisitResult.CXChildVisit_Recurse;
        }

        private static boolean isMatchingEssentialTypeCategory(String operator, EEssentialTypeCategory leftHandOperandCategory, EEssentialTypeCategory rightHandOperandCategory) {
            if (leftHandOperandCategory == rightHandOperandCategory) {
                return true;
            }
            if (OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.isEnumCategory(leftHandOperandCategory) || OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.isEnumCategory(rightHandOperandCategory)) {
                return true;
            }
            return OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.isMisraExceptionCaseAddition(operator, leftHandOperandCategory, rightHandOperandCategory) || OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.isMisraExceptionCaseSubtraction(operator, leftHandOperandCategory, rightHandOperandCategory);
        }

        private static boolean isEnumCategory(EEssentialTypeCategory operandCategory) {
            return operandCategory == EEssentialTypeCategory.ENUM;
        }

        private static boolean isMisraExceptionCaseAddition(String operator, EEssentialTypeCategory firstOperandCategory, EEssentialTypeCategory secondOperandCategory) {
            if (!"+".equals(operator) && !"+=".equals(operator)) {
                return false;
            }
            return OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.areCharacterAndSignedOrUnsignedCategory(firstOperandCategory, secondOperandCategory) || OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.areCharacterAndSignedOrUnsignedCategory(secondOperandCategory, firstOperandCategory);
        }

        private static boolean isMisraExceptionCaseSubtraction(String operator, EEssentialTypeCategory firstOperandCategory, EEssentialTypeCategory secondOperandCategory) {
            if (!"-".equals(operator) && !"-=".equals(operator)) {
                return false;
            }
            return OperandsOfBinaryOperatorMustHaveSameEssentialTypeCategoryCheckVisitor.areCharacterAndSignedOrUnsignedCategory(firstOperandCategory, secondOperandCategory);
        }

        private static boolean areCharacterAndSignedOrUnsignedCategory(EEssentialTypeCategory characterCategory, EEssentialTypeCategory signedOrUnsignedCategory) {
            return characterCategory == EEssentialTypeCategory.CHARACTER && (signedOrUnsignedCategory == EEssentialTypeCategory.SIGNED || signedOrUnsignedCategory == EEssentialTypeCategory.UNSIGNED);
        }

        private void createFinding(CXCursor cursor, EEssentialTypeCategory firstOperandCategory, EEssentialTypeCategory secondOperandCategory) {
            Optional textRegionLocation = ClangUtils.createTextRegionLocation((CXCursor)cursor);
            Optional completeNodeText = ClangUtils.getCompleteNodeText((CXCursor)cursor, (String)this.fileText);
            if (textRegionLocation.isEmpty() || completeNodeText.isEmpty()) {
                LOGGER.error("Unable to determine text region location " + String.valueOf(textRegionLocation) + " or expression text " + String.valueOf(completeNodeText) + " in file " + this.uniformPath);
                return;
            }
            String truncatedNodeText = StringUtils.truncateWithThreeDots((String)((String)completeNodeText.get()), (int)20);
            this.reportFinding((TextRegionLocation)textRegionLocation.get(), "Operands in binary arithmetic expression `" + truncatedNodeText + "` have different essential type categories _" + firstOperandCategory.readableName + "_ and _" + secondOperandCategory.readableName + "_");
        }
    }
}

