/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.arrays;

import eu.cqse.check.cpp.misra.arrays.ArrayAutomaton;
import eu.cqse.check.cpp.misra.arrays.ArrayAutomatonContext;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-array-initialization", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ArrayInitializationCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"local variable".equals(entity.getSubtype()) && !"global variable".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        Optional<ArrayAutomatonContext> arrayAutomatonContext = ArrayAutomatonContext.createArrayContext(entity);
        if (arrayAutomatonContext.isPresent()) {
            this.checkArray(arrayAutomatonContext.get(), entity);
        }
    }

    private void checkArray(ArrayAutomatonContext arrayAutomatonContext, ShallowEntity entity) {
        Optional<ArrayAutomaton> parsedAutomation = ArrayAutomaton.parse(arrayAutomatonContext);
        if (parsedAutomation.isPresent()) {
            ArrayAutomaton automaton = parsedAutomation.get();
            this.checkPartialInitialization(automaton, entity);
            this.checkMultipleInitialization(automaton, entity);
            this.checkEnclosingBraces(automaton, arrayAutomatonContext);
        } else {
            this.buildFinding("Array definition `" + entity.getName() + "` is not valid", this.buildLocation().betweenLines(entity.getStartLine(), entity.getEndLine())).createAndStore();
        }
    }

    private void checkPartialInitialization(ArrayAutomaton automaton, ShallowEntity entity) {
        if (automaton.isFullyInitialized()) {
            return;
        }
        this.buildFinding("Array `" + entity.getName() + "` should not be partially initialized", this.buildLocation().betweenLines(entity.getStartLine(), entity.getEndLine())).createAndStore();
    }

    private void checkMultipleInitialization(ArrayAutomaton automaton, ShallowEntity entity) {
        if (!automaton.anyMultipleInitialization()) {
            return;
        }
        List<int[]> indexes = automaton.getMultipleInitializations();
        ArrayList<String> indexTexts = new ArrayList<String>(indexes.size());
        for (int[] multiplyInitializedElementIndexes : indexes) {
            StringBuilder text = new StringBuilder("`");
            for (int indexItem : multiplyInitializedElementIndexes) {
                Optional<Map.Entry> alias = automaton.arrayOffsetAliasEnumNames.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(indexItem)).findAny();
                if (alias.isPresent()) {
                    text.append("[").append((String)alias.get().getKey()).append("]");
                    continue;
                }
                text.append("[").append(indexItem).append("]");
            }
            text.append("`");
            indexTexts.add(text.toString());
        }
        Object inferredMessageInfo = "Element";
        if (indexes.size() > 1) {
            inferredMessageInfo = (String)inferredMessageInfo + "s";
        }
        inferredMessageInfo = (String)inferredMessageInfo + " " + String.join((CharSequence)", ", indexTexts);
        this.buildFinding((String)inferredMessageInfo + " should only be initialized once", this.buildLocation().betweenLines(entity.getStartLine(), entity.getEndLine())).createAndStore();
    }

    private void checkEnclosingBraces(ArrayAutomaton automaton, ArrayAutomatonContext arrayAutomatonContext) {
        for (IToken token : automaton.getTokensToCreateCompoundFindingsFor()) {
            this.createCompoundFinding(arrayAutomatonContext, token);
        }
    }

    private void createCompoundFinding(ArrayAutomatonContext arrayAutomatonContext, IToken startToken) {
        List<IToken> compoundTokens = arrayAutomatonContext.getCompoundTokens(startToken);
        String inferredMessage = "`{" + StringUtils.truncateWithEllipsis((String)TokenStreamTextUtils.concatTokenTexts(compoundTokens), (int)50) + "}`";
        this.buildFinding("The use of enclosing braces is expected for " + inferredMessage, this.buildLocation().betweenTokens(startToken, compoundTokens.get(compoundTokens.size() - 1))).createAndStore();
    }
}

