/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.ConditionalStatementSubtypes;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionParserFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;

@Check(id="cqse-constant-condition", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ConstantConditionCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "Constant condition ({0} equivalent to {1})";
    private static final IConditionTreeNode FALSE = new ConditionTreeNodeFalse();
    private static final IConditionTreeNode TRUE = new ConditionTreeNodeTrue();

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        ELanguage language = this.context.getLanguage();
        if (!ConditionalStatementSubtypes.isConditionalStatement((ShallowEntity)entity, (ELanguage)language) || LanguageFeatureParser.CPP.containsMacroExpandedContent(entity)) {
            return;
        }
        IConditionExtractor conditionExtractor = ConditionParserFactory.createConditionExtractor((ELanguage)language);
        Condition condition = conditionExtractor.extractCondition(entity);
        if (condition == null || condition.isSingleLiteral() || condition.getTokens().size() == 1 && ((IToken)condition.getTokens().get(0)).getType().getTokenClass() == ETokenType.ETokenClass.KEYWORD) {
            return;
        }
        ConditionEvaluatorBase conditionEvaluator = ConditionEvaluatorFactory.createConditionEvaluator((ELanguage)language);
        IConditionTreeNode conditionTree = conditionEvaluator.getCanonicalRepresentation(condition);
        if (conditionTree.equals((Object)FALSE) || conditionTree.equals((Object)TRUE)) {
            this.buildFinding(MessageFormat.format(FINDINGS_MESSAGE, condition.getText(), conditionTree.toString()), this.buildLocation().forTokens((List)condition.getTokens())).createAndStore();
        }
    }
}

