/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-division-by-zero", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.OBJECTIVE_C, ELanguage.SWIFT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DivisionByZeroCheck
extends CheckImplementationBase {
    private static final String INT_ZERO = "0";
    private static final String MODULO_WITH_ZERO_MESSAGE = "Modulo with zero";
    private static final String DIV_BY_ZERO_MESSAGE = "Division by zero";

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        IToken divisor;
        UnmodifiableList tokens = entity.ownStartTokens();
        if (entity.getSubtype().equals("do while") || entity.getSubtype().equals("do")) {
            tokens = entity.ownEndTokens();
        }
        List indices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DIV, ETokenType.INTEGER_LITERAL});
        indices.addAll(TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DIVEQ, ETokenType.INTEGER_LITERAL}));
        for (Integer i : indices) {
            divisor = (IToken)tokens.get(i + 1);
            if (divisor.getType() != ETokenType.INTEGER_LITERAL || !divisor.getText().equals(INT_ZERO)) continue;
            this.buildFinding(DIV_BY_ZERO_MESSAGE, this.buildLocation().betweenTokens((IToken)tokens.get(i), divisor)).createAndStore();
        }
        indices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.MOD, ETokenType.INTEGER_LITERAL});
        indices.addAll(TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.MODEQ, ETokenType.INTEGER_LITERAL}));
        for (Integer i : indices) {
            divisor = (IToken)tokens.get(i + 1);
            if (divisor.getType() != ETokenType.INTEGER_LITERAL || !divisor.getText().equals(INT_ZERO)) continue;
            this.buildFinding(MODULO_WITH_ZERO_MESSAGE, this.buildLocation().betweenTokens((IToken)tokens.get(i), divisor)).createAndStore();
        }
    }
}

