/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.cs.NoParameterModifierBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-no-out-parameters", languages={ELanguage.CS, ELanguage.PLSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoOutParametersCheck
extends NoParameterModifierBase {
    protected static final String NAME = "Avoid using `out` on parameters";

    public NoOutParametersCheck() {
        super(ETokenType.OUT);
    }

    @Override
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        if (methods.isEmpty()) {
            return;
        }
        this.setModifiedParametersPatterBasedOnLanguage(methods);
        for (ShallowEntity method : methods) {
            if ("procedure".equals(method.getSubtype()) || !TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.OUT)) continue;
            this.processEntity(method);
        }
    }
}

