/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Check(id="cqse-return-in-finally", languages={ELanguage.CS, ELanguage.GROOVY, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PHP, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ReturnInFinallyCheck
extends CheckImplementationBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        Set<String> relevantFinallySubTypes = switch (this.context.getLanguage()) {
            case ELanguage.OBJECTIVE_C -> Set.of("@finally");
            case ELanguage.OBJECTIVE_CPP -> Set.of("@finally", "finally");
            default -> Set.of("finally");
        };
        List statementsInFinally = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT), entity -> relevantFinallySubTypes.contains(entity.getSubtype()), EnumSet.of(EShallowEntityType.STATEMENT));
        this.analyzeStatementsInFinally(statementsInFinally);
    }

    private void analyzeStatementsInFinally(List<ShallowEntity> statementsInFinally) {
        for (ShallowEntity statementInFinally : statementsInFinally) {
            if (!"simple statement".equals(statementInFinally.getSubtype()) || !TokenStreamUtils.contains((List)statementInFinally.ownStartTokens(), (ETokenType)ETokenType.RETURN) || PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage()) && PreprocessedTokenStreamUtils.firstTokenOfTypeIsFromMacro((List)statementInFinally.ownStartTokens(), EnumSet.of(ETokenType.RETURN))) continue;
            this.buildFinding("Return in `finally` block", this.buildLocation().forEntity(statementInFinally)).createAndStore();
        }
    }
}

