/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-do-not-declare-virtual-members-in-sealed-types", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotDeclareVirtualMembersInSealedTypesCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!TokenStreamUtils.containsAll((List)type.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.SEALED})) continue;
            List topLevelMethodsInType = CollectionUtils.filter((Collection)type.getChildren(), entity -> entity.getType() == EShallowEntityType.METHOD);
            this.processMethodsInSealedType(topLevelMethodsInType);
        }
    }

    private void processMethodsInSealedType(List<ShallowEntity> methodsInType) {
        for (ShallowEntity method : methodsInType) {
            if (!method.getSubtype().equals("method") || !TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.VIRTUAL) || TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.SEALED)) continue;
            this.buildFinding("A `sealed` type should not have `virtual` members", this.buildLocation().forEntity(method)).createAndStore();
        }
    }
}

