/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-use-params-for-variable-arguments", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseParamsForVariableArgumentsCheck
extends CheckImplementationBase {
    private static final String ARGLIST_IDENTIFIER = "__arglist";

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!TokenStreamUtils.containsAny((List)type.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED})) continue;
            for (ShallowEntity child : type.getChildren()) {
                if (child.getType() != EShallowEntityType.METHOD || !TokenStreamUtils.containsAny((List)child.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED})) continue;
                this.processEntity(child);
            }
        }
    }

    private void processEntity(ShallowEntity entity) {
        List parameterTokens = TokenStreamUtils.tokensBetweenWithNesting((List)entity.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        int argListIndex = TokenStreamTextUtils.findFirst((List)parameterTokens, (String)ARGLIST_IDENTIFIER);
        if (argListIndex != -1) {
            this.buildFinding("Use `params` instead of `__arglist` for variable arguments", this.buildLocation().forToken((IToken)parameterTokens.get(argListIndex))).createAndStore();
        }
    }
}

