/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.base.EntityFirstLineFindingCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-use-var-keyword-if-type-apparent", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseVarKeywordIfTypeApparentCheck
extends EntityFirstLineFindingCheckBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            UnmodifiableList tokens = statement.ownStartTokens();
            if (TokenStreamUtils.contains((List)tokens, (ETokenType)ETokenType.VAR) || !TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.AS}) && !TokenStreamUtils.containsSequence((List)tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.EQ, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.IDENTIFIER})) continue;
            this.processEntity(statement);
        }
    }

    protected String getFindingMessage(ShallowEntity entity) {
        return "The `var` keyword should be used if the type is defined on the right side";
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        int varNameIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ});
        if (varNameIndex == -1) {
            return;
        }
        List firstTypeTokens = tokens.subList(0, varNameIndex);
        List<IToken> secondTypeTokens = this.computeSecondTypeTokens(tokens.subList(varNameIndex + 1, tokens.size()));
        if (secondTypeTokens == null || firstTypeTokens.size() != secondTypeTokens.size()) {
            return;
        }
        for (int j = 0; j < firstTypeTokens.size(); ++j) {
            if (((IToken)firstTypeTokens.get(j)).getType() == secondTypeTokens.get(j).getType() && ((IToken)firstTypeTokens.get(j)).getText().equals(secondTypeTokens.get(j).getText())) continue;
            return;
        }
        super.processEntity(entity);
    }

    private @Nullable List<IToken> computeSecondTypeTokens(List<IToken> tokens) {
        List<IToken> secondTypeTokens;
        int newIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.NEW);
        if (newIndex != -1) {
            int lParenOrBraceIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)newIndex, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.LBRACE}));
            if (lParenOrBraceIndex == -1) {
                return null;
            }
            secondTypeTokens = tokens.subList(newIndex + 1, lParenOrBraceIndex);
        } else {
            int asIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.AS);
            if (asIndex != -1) {
                int semicolonOrParenIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)asIndex, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN}));
                secondTypeTokens = tokens.subList(asIndex + 1, semicolonOrParenIndex);
            } else {
                secondTypeTokens = tokens.subList(2, 3);
            }
        }
        return secondTypeTokens;
    }
}

