/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.hana_views.HanaViewsCheckUtil;
import java.util.regex.Pattern;

@Check(id="cqse-object-names-must-not-contain-special-characters", languages={ELanguage.HANA_VIEW})
public class ObjectNamesMustNotContainSpecialCharactersCheck
extends CheckImplementationBase {
    private static final Pattern OBJECT_NAME_PATTERN = Pattern.compile("^[a-zA-Z_0-9]+$");

    public void execute() throws CheckException {
        String objectName = HanaViewsCheckUtil.getRepositoryObjectName(this.context);
        if (OBJECT_NAME_PATTERN.matcher(objectName).matches()) {
            return;
        }
        this.buildFinding("Object name '" + objectName + "' contains special character", this.buildLocation().forElement()).createAndStore();
    }
}

