/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-insecure-hash-algorithms", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidInsecureHashAlgorithmsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_INSECURE_CLASS = "Avoid usage of classes based on insecure hash algorithms like SHA1 and MD5";
    private static final String FINDING_MESSAGE_INSECURE_ALGORITHM = "Avoid usage of insecure hash algorithms like SHA1 and MD5";
    private static final Set<String> USABLE_HASH_ALGORITHM_CLASSES = CollectionUtils.asHashSet((Object[])new String[]{"Hashing", "KeyGenerator", "DigestUtils", "Mac", "KeyPairGenerator", "KeyFactory", "AlgorithmParameters", "AlgorithmParameterGenerator", "MessageDigest", "Signature"});
    private static final Set<String> ALL_HASH_ALGORITHM_CLASSES = CollectionUtils.asHashSet((Object[])new String[]{"Hashing", "KeyGenerator", "DigestUtils", "Mac", "KeyPairGenerator", "KeyFactory", "AlgorithmParameters", "AlgorithmParameterGenerator", "MessageDigest", "Signature", "ShaPasswordEncoder", "Md5PasswordEncoder", "LdapShaPasswordEncoder", "Md4PasswordEncoder", "MessageDigestPasswordEncoder", "NoOpPasswordEncoder", "StandardPasswordEncoder"});
    private static final Set<String> INSECURE_HASH_ALGORITHMS = CollectionUtils.asHashSet((Object[])new String[]{"\"SHA1\"", "\"MD5\"", "\"MD2\"", "\"MD4\"", "\"MD6\"", "\"HAVAL-128\"", "\"HMAC-MD5\"", "\"DSA\"", "\"RIPEMD\"", "\"RIPEMD-128\"", "\"RIPMED-160\"", "\"HMACRIPEMD160\""});
    private final Set<ShallowEntity> insecureVariables = new HashSet<ShallowEntity>();

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.includedTokens();
        if (entityTokens.isEmpty()) {
            return;
        }
        String firstTokenText = ((IToken)entityTokens.get(0)).getText();
        if (USABLE_HASH_ALGORITHM_CLASSES.contains(firstTokenText)) {
            this.checkForInsecureAlgorithmReference(entity, (UnmodifiableList<IToken>)entityTokens);
        } else if (ALL_HASH_ALGORITHM_CLASSES.contains(firstTokenText)) {
            this.buildFinding(FINDING_MESSAGE_INSECURE_CLASS, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        } else if (entity.getSubtype().equals("local variable") || entity.getType().equals((Object)EShallowEntityType.ATTRIBUTE)) {
            for (IToken token : entityTokens) {
                if (token.getType() != ETokenType.STRING_LITERAL || !INSECURE_HASH_ALGORITHMS.contains(token.getText())) continue;
                this.insecureVariables.add(entity);
            }
        }
    }

    private void checkForInsecureAlgorithmReference(ShallowEntity entity, UnmodifiableList<IToken> entityTokens) throws CheckException {
        ScopedTypeLookup entitiesTypeResolution = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        for (IToken token : entityTokens) {
            String maybeHashAlgorithm = token.getText();
            if (INSECURE_HASH_ALGORITHMS.parallelStream().anyMatch(maybeHashAlgorithm::contains)) {
                this.buildFinding(FINDING_MESSAGE_INSECURE_ALGORITHM, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
            if (!entitiesTypeResolution.containsVariable(maybeHashAlgorithm) || !this.insecureVariables.contains(entitiesTypeResolution.getTypeInfo(maybeHashAlgorithm).getDeclaringEntity())) continue;
            this.buildFinding(FINDING_MESSAGE_INSECURE_ALGORITHM, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

