/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;

@Check(id="java:S5876", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CreateNewSpringFrameworkSessionCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher SESSION_MANAGER_CALLS = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.security.config.annotation.web.builders.HttpSecurity"}).withTargetMethodNames(new String[]{"sessionManagement"}).withParameterCount(0, 1);
    private static final TokenPattern CHAINED_NONE_CALL = new TokenPattern().skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).sequence(new Object[]{ETokenType.DOT}).tokenText("none").group(0).sequence(new Object[]{ETokenType.LPAREN, ETokenType.RPAREN});
    private static final TokenPattern LAMBDA_NONE_CALL = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.ARROW}).skipTo(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).tokenText("none").group(0).sequence(new Object[]{ETokenType.LPAREN, ETokenType.RPAREN})});
    private static final TokenPattern LAMBDA_DOUBLE_COLON_NONE_CALL = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipTo(new Object[]{ETokenType.DOUBLE_COLON}).tokenText("none").group(0).sequence(new Object[]{ETokenType.RPAREN});
    private static final TokenPattern NO_SESSION_MANAGEMENT_PATTERN = new TokenPattern().tokenText("sessionFixation").alternative(new Object[]{CHAINED_NONE_CALL, LAMBDA_NONE_CALL, LAMBDA_DOUBLE_COLON_NONE_CALL});

    public void execute() throws CheckException {
        for (JavaMethodCallMatcher.MethodCall methodCall : SESSION_MANAGER_CALLS.find(this.context, new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption())))) {
            this.checkSessionManagement(methodCall);
        }
    }

    private void checkSessionManagement(JavaMethodCallMatcher.MethodCall methodCall) {
        TokenPatternMatch match = NO_SESSION_MANAGEMENT_PATTERN.findFirstMatch((List)methodCall.entity().includedTokens());
        if (match != null) {
            this.buildFinding("Create a new session during user authentication to prevent session fixation attacks", this.buildLocation().forToken((IToken)match.groupTokens(0).getFirst())).createAndStore();
        }
    }
}

