/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.JavaClassInformationExtractorPhase;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="java:S110", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={JavaClassInformationExtractorPhase.class})
public class DepthOfInheritanceTreeCheck
extends CheckImplementationBase {
    @CheckOption(name="max (java:S110)", description="Maximum depth of the inheritance tree")
    private int max = 5;
    @CheckOption(name="filteredClasses (java:S110)", description="Classes to be ignored for inheritance tree. A list of either a fully qualified type, a wildcard like android.** for matching any type below that package or a wildcard like java.lang.* for matching a type directly in that package", multilineText=true)
    private Set<String> filteredClasses = Set.of("android.**", "com.intellij.**", "com.persistit.**", "javax.swing.**", "javafx.scene.**", "org.eclipse.**", "org.springframework.**");
    private static final int MAX_DEPTH = 99;
    private JavaImportSensitiveTypeResolver typeResolver;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        this.check((List<ShallowEntity>)this.context.getRootEntity(this.getCodeViewOption()).getChildren());
    }

    private void check(List<ShallowEntity> children) {
        for (ShallowEntity entity : children) {
            this.handleType(entity);
            this.check((List<ShallowEntity>)entity.getChildren());
        }
    }

    private void handleType(ShallowEntity entity) {
        String message;
        int initialDepth;
        if (EShallowEntityType.TYPE != entity.getType()) {
            return;
        }
        if (entity.getSubtype().equals("anonymous class")) {
            initialDepth = 1;
            message = "Anonymous class of %s has inheritance depth of %s which is deeper than maximum of %s";
        } else {
            initialDepth = 0;
            message = "%s has inheritance depth of %s which is deeper than maximum of %s";
        }
        Set possibleTypes = LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(this.typeResolver, entity, Objects.requireNonNull(entity.getName()));
        int depth = possibleTypes.stream().map(type -> this.calculateDepth((String)type, initialDepth)).max(Integer::compareTo).get();
        if (depth > this.max) {
            this.buildFinding(String.format(message, MarkupUtils.formatAsSourceCode((String)entity.getName()), depth, this.max), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private int calculateDepth(String className, int depthAccumulator) {
        if (depthAccumulator >= 99) {
            return 99;
        }
        List phaseResult = (List)this.context.accessPhaseInvertedResult(JavaClassInformationExtractorPhase.class).apply(className);
        Set possibleSuperclasses = phaseResult.stream().flatMap(c -> c.getAdditionalInformation().possibleSuperclasses().stream()).collect(Collectors.toSet());
        if (!possibleSuperclasses.isEmpty()) {
            return possibleSuperclasses.stream().map(possibleSuperclass -> {
                boolean ignoreSuperClass = this.filteredClasses.stream().anyMatch(filteredClass -> DepthOfInheritanceTreeCheck.matchesWildcardPattern(possibleSuperclass, filteredClass));
                if (ignoreSuperClass) {
                    return depthAccumulator;
                }
                return this.calculateDepth((String)possibleSuperclass, depthAccumulator + 1);
            }).max(Integer::compare).get();
        }
        if (this.filteredClasses.contains("java.lang.Object")) {
            return depthAccumulator;
        }
        return depthAccumulator + 1;
    }

    public static boolean matchesWildcardPattern(String className, String wildcardPattern) {
        if (wildcardPattern.endsWith("**")) {
            return className.startsWith(wildcardPattern.substring(0, wildcardPattern.length() - 2));
        }
        if (wildcardPattern.endsWith("*")) {
            return className.startsWith(wildcardPattern.substring(0, wildcardPattern.length() - 1)) && !className.substring(wildcardPattern.length() - 1).contains(".");
        }
        return className.equals(wildcardPattern);
    }
}

