/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="java:S5810", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class JUnit5SilentlyIgnoreClassAndMethodCheck
extends CheckImplementationBase {
    private boolean hasNoJunit5Import = false;

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        this.hasNoJunit5Import = ((List)LanguageFeatureParser.JAVA.getTestFrameworkImports(ast).getCollectionOrEmpty((Object)EJavaTestFramework.JUNIT_5)).isEmpty();
        this.checkJUnitMethods();
        this.checkClassesWithJUnitNestedAnnotation();
    }

    private void checkJUnitMethods() throws CheckException {
        List<ShallowEntity> junitTestMethods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD).stream().filter(this::isJunit5TestMethod).toList();
        for (ShallowEntity method : junitTestMethods) {
            List methodReturnTypeTokens;
            if (LanguageFeatureParser.JAVA.hasExplicitVisibility(method, ETokenType.PRIVATE)) {
                this.buildFinding("Remove this `private` modifier", this.buildLocation().forEntityFirstLine(method)).createAndStore();
            }
            if (LanguageFeatureParser.JAVA.isStatic(method)) {
                this.buildFinding("Remove this `static` modifier", this.buildLocation().forEntityFirstLine(method)).createAndStore();
            }
            if ((methodReturnTypeTokens = LanguageFeatureParser.JAVA.getMethodReturnType(method)).isEmpty() || methodReturnTypeTokens.size() <= 1 && ((IToken)methodReturnTypeTokens.getFirst()).getType() == ETokenType.VOID) continue;
            this.buildFinding("Replace the return type by `void`", this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private void checkClassesWithJUnitNestedAnnotation() throws CheckException {
        List<ShallowEntity> privateClassesMarkedWithNested = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(type -> this.isJunit5NestedClass((ShallowEntity)type) && LanguageFeatureParser.JAVA.hasExplicitVisibility(type, ETokenType.PRIVATE)).toList();
        for (ShallowEntity typeMarkedWithNested : privateClassesMarkedWithNested) {
            boolean hasAnyTestMethods = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(typeMarkedWithNested), (EShallowEntityType)EShallowEntityType.METHOD).stream().anyMatch(this::isJunit5TestMethod);
            if (!hasAnyTestMethods) continue;
            this.buildFinding("Remove this `private` modifier", this.buildLocation().forEntityFirstLine(typeMarkedWithNested)).createAndStore();
        }
    }

    private boolean isJunit5TestMethod(ShallowEntity method) {
        return this.isJunit5TestAnnotation(method, "Test");
    }

    private boolean isJunit5NestedClass(ShallowEntity type) {
        return this.isJunit5TestAnnotation(type, "Nested");
    }

    private boolean isJunit5TestAnnotation(ShallowEntity method, String simpleName) {
        String fullyQualifiedTestAnnotation = EJavaTestFramework.JUNIT_5.getNamespacePrefix() + simpleName;
        if (this.hasNoJunit5Import) {
            return LanguageFeatureParser.JAVA.hasAnnotation(method, (Set)CollectionUtils.asHashSet((Object[])new String[]{fullyQualifiedTestAnnotation}));
        }
        return LanguageFeatureParser.JAVA.hasAnnotation(method, (Set)CollectionUtils.asHashSet((Object[])new String[]{simpleName, fullyQualifiedTestAnnotation}));
    }
}

