/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import java.util.List;

@Check(id="cqse-junit-assert-with-multiple-conditions", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class JUnitAssertWithMultipleConditionsCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher JUNIT_METHOD_MATCHER = JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.JUNIT_4.getAssertionTypes()).onTypes(EJavaTestFramework.JUNIT_5.getAssertionTypes()).withTargetMethodNames(new String[]{"assertTrue", "assertFalse"}).withParameters(parameters -> parameters.size() == 1 && TokenStreamUtils.containsAny((List)((List)parameters.getFirst()), (ETokenType[])new ETokenType[]{ETokenType.ANDAND, ETokenType.OROR, ETokenType.AND, ETokenType.OR, ETokenType.XOR}));

    public void execute() throws CheckException {
        for (JavaMethodCallMatcher.MethodCall methodCall : JUNIT_METHOD_MATCHER.find(this.context, new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption())))) {
            this.buildFinding("More than one condition found in `" + methodCall.methodName() + "` statement", this.buildLocation().forEntity(methodCall.entity())).createAndStore();
        }
    }
}

